"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentsSelectionStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Divider = _styledComponents.default.div`
  width: 0;
  height: ${props => props.theme.eui.euiSizeL};
  border-left: ${props => props.theme.eui.euiBorderThin};
`;
const FlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  height: ${props => props.theme.eui.euiSizeL};
`;
const Button = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  .euiButtonEmpty__text {
    font-size: ${props => props.theme.eui.euiFontSizeXS};
  }
`;
const AgentsSelectionStatus = ({
  totalAgents,
  selectableAgents,
  managedAgentsOnCurrentPage,
  selectionMode,
  setSelectionMode,
  selectedAgents,
  setSelectedAgents
}) => {
  const showSelectionInfoAndOptions = selectionMode === 'manual' && selectedAgents.length > 0 || selectionMode === 'query' && totalAgents > 0;
  const showSelectEverything = selectionMode === 'manual' && selectedAgents.length === selectableAgents && selectableAgents < totalAgents - managedAgentsOnCurrentPage;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, totalAgents > _constants.SO_SEARCH_LIMIT ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentBulkActions.totalAgentsWithLimit",
    defaultMessage: "Showing {count} of {total} agents",
    values: {
      count: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: _constants.SO_SEARCH_LIMIT
      }),
      total: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: totalAgents
      })
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentBulkActions.totalAgents",
    defaultMessage: "Showing {count, plural, one {# agent} other {# agents}}",
    values: {
      count: totalAgents
    }
  }))), showSelectionInfoAndOptions ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(Divider, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    "data-test-subj": "selectedAgentCountLabel"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentBulkActions.agentsSelected",
    defaultMessage: "{count, plural, one {# agent} other {# agents} =all {All agents}} selected",
    values: {
      count: selectionMode === 'manual' ? selectedAgents.length : 'all'
    }
  }))), showSelectEverything ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(Divider, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(Button, {
    size: "xs",
    flush: "left",
    "data-test-subj": "selectedEverythingOnAllPagesButton",
    onClick: () => setSelectionMode('query')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentBulkActions.selectAll",
    defaultMessage: "Select everything on all pages"
  })))) : null, /*#__PURE__*/_react.default.createElement(FlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(Divider, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(Button, {
    size: "xs",
    flush: "left",
    "data-test-subj": "clearAgentSelectionButton",
    onClick: () => {
      setSelectionMode('manual');
      setSelectedAgents([]);
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentBulkActions.clearSelection",
    defaultMessage: "Clear selection"
  })))) : /*#__PURE__*/_react.default.createElement(FlexItem, {
    grow: false
  })));
};
exports.AgentsSelectionStatus = AgentsSelectionStatus;