"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogLevelFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LEVEL_VALUES = Object.values(_constants.AGENT_LOG_LEVELS);
const LogLevelFilter = /*#__PURE__*/(0, _react.memo)(({
  selectedLevels,
  onToggleLevel
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsOpen(prevIsOpen => !prevIsOpen), []);
  const closePopover = (0, _react.useCallback)(() => setIsOpen(false), []);
  const filterSelect = LEVEL_VALUES.map(level => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
    checked: selectedLevels.includes(level) ? 'on' : undefined,
    key: level,
    onClick: () => onToggleLevel(level)
  }, level));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": "agentList.logLevelFilterBtn",
      iconType: "arrowDown",
      onClick: togglePopover,
      isSelected: isOpen,
      numFilters: LEVEL_VALUES.length,
      hasActiveFilters: selectedLevels.length > 0,
      numActiveFilters: selectedLevels.length
    }, _i18n.i18n.translate('xpack.fleet.agentLogs.logLevelSelectText', {
      defaultMessage: 'Log level'
    })),
    isOpen: isOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, filterSelect);
});
exports.LogLevelFilter = LogLevelFilter;