"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentDiagnosticsTab = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _services = require("../../../../../../../../common/services");
var _hooks = require("../../../../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlexStartEuiFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  align-self: flex-start;
`;
const MarginedIcon = (0, _styledComponents.default)(_eui.EuiIcon)`
  margin-right: 7px;
`;
const AgentDiagnosticsTab = ({
  agent
}) => {
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    getAbsolutePath
  } = (0, _hooks.useLink)();
  const [isSubmitting, setIsSubmitting] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [diagnosticsEntries, setDiagnosticEntries] = (0, _react.useState)([]);
  const [prevDiagnosticsEntries, setPrevDiagnosticEntries] = (0, _react.useState)([]);
  const [loadInterval, setLoadInterval] = (0, _react.useState)(10000);
  const loadData = (0, _react.useCallback)(async () => {
    try {
      const uploadsResponse = await (0, _hooks.sendGetAgentUploads)(agent.id);
      const error = uploadsResponse.error;
      if (error) {
        throw error;
      }
      if (!uploadsResponse.data) {
        throw new Error('No data');
      }
      const entries = uploadsResponse.data.items;
      setDiagnosticEntries(entries);
      setIsLoading(false);

      // query faster if an action is in progress, for quicker feedback
      if (entries.some(entry => entry.status === 'IN_PROGRESS' || entry.status === 'AWAITING_UPLOAD')) {
        setLoadInterval(3000);
      } else {
        setLoadInterval(10000);
      }
    } catch (err) {
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.fleet.requestDiagnostics.errorLoadingUploadsNotificationTitle', {
          defaultMessage: 'Error loading diagnostics uploads'
        })
      });
    }
  }, [agent.id, notifications.toasts, setLoadInterval]);
  (0, _react.useEffect)(() => {
    loadData();
    const interval = setInterval(async () => {
      loadData();
    }, loadInterval);
    const cleanup = () => {
      if (interval) {
        clearInterval(interval);
      }
    };
    return cleanup;
  }, [loadData, loadInterval]);
  (0, _react.useEffect)(() => {
    setPrevDiagnosticEntries(diagnosticsEntries);
    if (prevDiagnosticsEntries.length > 0) {
      diagnosticsEntries.filter(newEntry => {
        const oldEntry = prevDiagnosticsEntries.find(entry => entry.id === newEntry.id);
        return newEntry.status === 'READY' && (!oldEntry || (oldEntry === null || oldEntry === void 0 ? void 0 : oldEntry.status) !== 'READY');
      }).forEach(entry => {
        notifications.toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.fleet.requestDiagnostics.readyNotificationTitle', {
            defaultMessage: 'Agent diagnostics {name} ready',
            values: {
              name: entry.name
            }
          })
        }, {
          toastLifeTimeMs: 5000
        });
      });
    }
  }, [prevDiagnosticsEntries, diagnosticsEntries, notifications.toasts]);
  const errorIcon = /*#__PURE__*/_react.default.createElement(MarginedIcon, {
    type: "warning",
    color: "red"
  });
  const getErrorMessage = error => error ? `Error: ${error}` : '';
  const columns = [{
    field: 'id',
    name: 'File',
    render: id => {
      const currentItem = diagnosticsEntries.find(item => item.id === id);
      return (currentItem === null || currentItem === void 0 ? void 0 : currentItem.status) === 'READY' ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: getAbsolutePath(currentItem === null || currentItem === void 0 ? void 0 : currentItem.filePath),
        download: true,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "download"
      }), " \xA0 ", currentItem === null || currentItem === void 0 ? void 0 : currentItem.name) : (currentItem === null || currentItem === void 0 ? void 0 : currentItem.status) === 'IN_PROGRESS' || (currentItem === null || currentItem === void 0 ? void 0 : currentItem.status) === 'AWAITING_UPLOAD' ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        color: "subdued",
        disabled: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null), " \xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.requestDiagnostics.generatingText",
        defaultMessage: "Generating diagnostics file..."
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        color: "subdued",
        disabled: true
      }, currentItem !== null && currentItem !== void 0 && currentItem.status ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, "Diagnostics status: ", currentItem === null || currentItem === void 0 ? void 0 : currentItem.status), /*#__PURE__*/_react.default.createElement("p", null, getErrorMessage(currentItem === null || currentItem === void 0 ? void 0 : currentItem.error)))
      }, errorIcon) : errorIcon, "\xA0", currentItem === null || currentItem === void 0 ? void 0 : currentItem.name);
    }
  }, {
    field: 'id',
    name: 'Date',
    dataType: 'date',
    render: id => {
      const currentItem = diagnosticsEntries.find(item => item.id === id);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: (currentItem === null || currentItem === void 0 ? void 0 : currentItem.status) === 'READY' ? 'default' : 'subdued'
      }, (0, _eui.formatDate)(currentItem === null || currentItem === void 0 ? void 0 : currentItem.createTime, 'lll'));
    }
  }];
  async function onSubmit() {
    try {
      setIsSubmitting(true);
      const {
        error
      } = await (0, _hooks.sendPostRequestDiagnostics)(agent.id);
      if (error) {
        throw error;
      }
      setIsSubmitting(false);
      const successMessage = _i18n.i18n.translate('xpack.fleet.requestDiagnostics.successSingleNotificationTitle', {
        defaultMessage: 'Request diagnostics submitted'
      });
      notifications.toasts.addSuccess(successMessage);
      loadData();
    } catch (error) {
      setIsSubmitting(false);
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.requestDiagnostics.fatalErrorNotificationTitle', {
          defaultMessage: 'Error requesting diagnostics {count, plural, one {agent} other {agents}}',
          values: {
            count: 1
          }
        })
      });
    }
  }
  const requestDiagnosticsButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    size: "m",
    onClick: onSubmit,
    disabled: isSubmitting || !(0, _services.isAgentRequestDiagnosticsSupported)(agent)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.diagnosticsOneButton",
    defaultMessage: "Request diagnostics .zip"
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    color: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.calloutTitle",
      defaultMessage: "Agent diagnostics"
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.requestDiagnostics.calloutText",
    defaultMessage: "Diagnostics files are stored in Elasticsearch, and as such can incur storage costs."
  }))), /*#__PURE__*/_react.default.createElement(FlexStartEuiFlexItem, null, (0, _services.isAgentRequestDiagnosticsSupported)(agent) ? requestDiagnosticsButton : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.requestDiagnostics.notSupportedTooltip",
      defaultMessage: "Requesting agent diagnostics is not supported for agents before version {version}.",
      values: {
        version: _services.MINIMUM_DIAGNOSTICS_AGENT_VERSION
      }
    })
  }, requestDiagnosticsButton)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: diagnosticsEntries,
    columns: columns
  })));
};
exports.AgentDiagnosticsTab = AgentDiagnosticsTab;