"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoPackagePolicies = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../hooks");
var _constants = require("../../../../../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoPackagePolicies = /*#__PURE__*/(0, _react.memo)(({
  policyId
}) => {
  const {
    application
  } = (0, _hooks.useStartServices)();
  const canWriteIntegrationPolicies = (0, _hooks.useAuthz)().integrations.writeIntegrationPolicies;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "plusInCircle",
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.policyDetailsPackagePolicies.createFirstTitle",
      defaultMessage: "Add your first integration"
    })),
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.policyDetailsPackagePolicies.createFirstMessage",
      defaultMessage: "This policy does not have any integrations yet."
    }),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "plusInCircle",
      isDisabled: !canWriteIntegrationPolicies,
      fill: true,
      onClick: () => application.navigateToApp(_constants.INTEGRATIONS_PLUGIN_ID, {
        path: _constants.pagePathGetters.integrations_all({})[1],
        state: {
          forAgentPolicyId: policyId
        }
      }),
      "data-test-subj": "addPackagePolicyButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.policyDetailsPackagePolicies.createFirstButtonText",
      defaultMessage: "Add integration"
    }))
  });
});
exports.NoPackagePolicies = NoPackagePolicies;