"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePoliciesView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hooks = require("../../../../../hooks");
var _no_package_policies = require("./no_package_policies");
var _package_policies_table = require("./package_policies_table");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PackagePoliciesView = /*#__PURE__*/(0, _react.memo)(({
  agentPolicy
}) => {
  (0, _hooks.useBreadcrumbs)('policy_details', {
    policyName: agentPolicy.name
  });
  if (!agentPolicy.package_policies || agentPolicy.package_policies.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_no_package_policies.NoPackagePolicies, {
      policyId: agentPolicy.id
    });
  }
  return /*#__PURE__*/_react.default.createElement(_package_policies_table.PackagePoliciesTable, {
    agentPolicy: agentPolicy,
    packagePolicies: agentPolicy.package_policies
  });
});
exports.PackagePoliciesView = PackagePoliciesView;