"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeployAgentPolicyModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmDeployAgentPolicyModal = ({
  onConfirm,
  onCancel,
  agentCount,
  agentPolicy
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicy.confirmModalTitle",
      defaultMessage: "Save and deploy changes"
    }),
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicy.confirmModalCancelButtonLabel",
      defaultMessage: "Cancel"
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicy.confirmModalConfirmButtonLabel",
      defaultMessage: "Save and deploy changes"
    }),
    buttonColor: "primary"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "iInCircle",
    title: _i18n.i18n.translate('xpack.fleet.agentPolicy.confirmModalCalloutTitle', {
      defaultMessage: 'This action will update {agentCount, plural, one {# agent} other {# agents}}',
      values: {
        agentCount
      }
    })
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.confirmModalCalloutDescription",
    defaultMessage: "Fleet has detected that the selected agent policy, {policyName}, is already in use by some of your agents. As a result of this action, Fleet will deploy updates to all agents that use this policy.",
    values: {
      policyName: /*#__PURE__*/_react.default.createElement("b", null, agentPolicy.name)
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.confirmModalDescription",
    defaultMessage: "This action can not be undone. Are you sure you wish to continue?"
  }));
};
exports.ConfirmDeployAgentPolicyModal = ConfirmDeployAgentPolicyModal;