"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAPMServiceDetailHref = void 0;
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _use_locator = require("../../../hooks/use_locator");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isAPMIntegration = datastream => Boolean(datastream.package === 'apm');
const useAPMServiceDetailHref = datastream => {
  const apmLocator = (0, _use_locator.useLocator)(_constants.LOCATORS_IDS.APM_LOCATOR);
  const {
    error,
    loading,
    value
  } = (0, _useAsync.default)(() => {
    if (!isAPMIntegration(datastream) || !apmLocator) return Promise.resolve();
    if (datastream.serviceDetails) {
      const {
        serviceName,
        environment
      } = datastream.serviceDetails;
      return apmLocator.getUrl({
        serviceName,
        serviceOverviewTab: datastream.type === 'logs' ? 'errors' : datastream.type,
        query: {
          environment
        }
      });
    }
    return apmLocator.getUrl({
      serviceName: undefined
    });
  });
  return {
    isSuccessful: !error && !loading,
    href: value
  };
};
exports.useAPMServiceDetailHref = useAPMServiceDetailHref;