"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.importerFactory = importerFactory;
var _message_importer = require("./message_importer");
var _ndjson_importer = require("./ndjson_importer");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function importerFactory(format, options) {
  switch (format) {
    // delimited and semi-structured text are both handled by splitting the
    // file into messages, then sending these to ES for further processing
    // in an ingest pipeline in documents containing a single "message"
    // field (like Filebeat does)
    case _constants.FILE_FORMATS.DELIMITED:
    case _constants.FILE_FORMATS.SEMI_STRUCTURED_TEXT:
      return new _message_importer.MessageImporter(options);
    case _constants.FILE_FORMATS.NDJSON:
      return new _ndjson_importer.NdjsonImporter();
    default:
      return;
  }
}