"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexNameFormComponent = exports.FileUploadComponent = void 0;
exports.analyzeFile = analyzeFile;
exports.checkIndexExists = checkIndexExists;
exports.getTimeFieldRange = getTimeFieldRange;
exports.hasImportPermission = hasImportPermission;
exports.importerFactory = importerFactory;
var _lazy_load_bundle = require("../lazy_load_bundle");
var _geo_upload_wizard_async_wrapper = require("./geo_upload_wizard_async_wrapper");
var _index_name_form_async_wrapper = require("./index_name_form_async_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileUploadComponent = _geo_upload_wizard_async_wrapper.GeoUploadWizardAsyncWrapper;
exports.FileUploadComponent = FileUploadComponent;
const IndexNameFormComponent = _index_name_form_async_wrapper.IndexNameFormAsyncWrapper;
exports.IndexNameFormComponent = IndexNameFormComponent;
async function importerFactory(format, options) {
  const fileUploadModules = await (0, _lazy_load_bundle.lazyLoadModules)();
  return fileUploadModules.importerFactory(format, options);
}
async function analyzeFile(file, params = {}) {
  const {
    getHttp
  } = await (0, _lazy_load_bundle.lazyLoadModules)();
  const body = JSON.stringify(file);
  return await getHttp().fetch({
    path: `/internal/file_upload/analyze_file`,
    method: 'POST',
    version: '1',
    body,
    query: params
  });
}
async function hasImportPermission(params) {
  const fileUploadModules = await (0, _lazy_load_bundle.lazyLoadModules)();
  try {
    const resp = await fileUploadModules.getHttp().fetch({
      path: `/internal/file_upload/has_import_permission`,
      method: 'GET',
      version: '1',
      query: {
        ...params
      }
    });
    return resp.hasImportPermission;
  } catch (error) {
    return false;
  }
}
async function checkIndexExists(index, params = {}) {
  const body = JSON.stringify({
    index
  });
  const fileUploadModules = await (0, _lazy_load_bundle.lazyLoadModules)();
  try {
    const {
      exists
    } = await fileUploadModules.getHttp().fetch({
      path: `/internal/file_upload/index_exists`,
      method: 'POST',
      version: '1',
      body,
      query: params
    });
    return exists;
  } catch (error) {
    return false;
  }
}
async function getTimeFieldRange(index, query, timeFieldName) {
  const body = JSON.stringify({
    index,
    timeFieldName,
    query
  });
  const fileUploadModules = await (0, _lazy_load_bundle.lazyLoadModules)();
  return await fileUploadModules.getHttp().fetch({
    path: `/internal/file_upload/time_field_range`,
    method: 'POST',
    version: '1',
    body
  });
}