"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isReferenceLineOrLayer = exports.isReferenceLineDecorationConfig = exports.isReferenceLine = exports.isReferenceLayer = exports.isDataLayer = exports.isAnnotationsLayer = exports.getReferenceLayers = exports.getDataLayers = void 0;
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isDataLayer = layer => layer.layerType === _constants.LayerTypes.DATA || !layer.layerType;
exports.isDataLayer = isDataLayer;
const getDataLayers = layers => (layers || []).filter(layer => isDataLayer(layer));
exports.getDataLayers = getDataLayers;
const isReferenceLayer = layer => layer.layerType === _constants.LayerTypes.REFERENCELINE && layer.type === _constants.REFERENCE_LINE_LAYER;
exports.isReferenceLayer = isReferenceLayer;
const isReferenceLine = layer => layer.type === _constants.REFERENCE_LINE;
exports.isReferenceLine = isReferenceLine;
const isReferenceLineDecorationConfig = decoration => decoration.type === _constants.EXTENDED_REFERENCE_LINE_DECORATION_CONFIG;
exports.isReferenceLineDecorationConfig = isReferenceLineDecorationConfig;
const isReferenceLineOrLayer = layer => layer.layerType === _constants.LayerTypes.REFERENCELINE;
exports.isReferenceLineOrLayer = isReferenceLineOrLayer;
const getReferenceLayers = layers => (layers || []).filter(layer => isReferenceLayer(layer) || isReferenceLine(layer));
exports.getReferenceLayers = getReferenceLayers;
const isAnnotationLayerCommon = layer => layer.layerType === _constants.LayerTypes.ANNOTATIONS;
const isAnnotationsLayer = layer => isAnnotationLayerCommon(layer);
exports.isAnnotationsLayer = isAnnotationsLayer;