"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SplitChart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _utils = require("@kbn/visualizations-plugin/common/utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SPLIT_COLUMN = '__split_column__';
const SPLIT_ROW = '__split_row__';
const SplitChart = ({
  splitColumnAccessor,
  splitRowAccessor,
  columns
}) => {
  const getData = (0, _react.useCallback)((datum, accessor) => {
    const splitColumn = (0, _utils.getColumnByAccessor)(accessor, columns);
    return datum[splitColumn.id];
  }, [columns]);
  return splitColumnAccessor || splitRowAccessor ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, splitColumnAccessor && /*#__PURE__*/_react.default.createElement(_charts.GroupBy, {
    id: SPLIT_COLUMN,
    by: (spec, datum) => getData(datum, splitColumnAccessor),
    sort: _charts.Predicate.DataIndex
  }), splitRowAccessor && /*#__PURE__*/_react.default.createElement(_charts.GroupBy, {
    id: SPLIT_ROW,
    by: (spec, datum) => getData(datum, splitRowAccessor),
    sort: _charts.Predicate.DataIndex
  }), /*#__PURE__*/_react.default.createElement(_charts.SmallMultiples, {
    splitVertically: splitRowAccessor ? SPLIT_ROW : undefined,
    splitHorizontally: splitColumnAccessor ? SPLIT_COLUMN : undefined
  })) : null;
};
exports.SplitChart = SplitChart;