"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendActionPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/cell-actions/constants");
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const hasFilterCellAction = actions => {
  return actions.some(({
    type
  }) => type === _constants.FILTER_CELL_ACTION_TYPE);
};
const LegendActionPopover = ({
  label,
  onFilter,
  legendCellValueActions = []
}) => {
  const [popoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const [ref, onClose] = (0, _charts.useLegendAction)();
  const panels = (0, _react.useMemo)(() => {
    const defaultFilterActions = [{
      id: 'filterIn',
      displayName: _i18n.i18n.translate('expressionXY.legend.filterForValueButtonAriaLabel', {
        defaultMessage: 'Filter for'
      }),
      'data-test-subj': `legend-${label}-filterIn`,
      iconType: 'plusInCircle',
      execute: () => {
        setPopoverOpen(false);
        onFilter();
      }
    }, {
      id: 'filterOut',
      displayName: _i18n.i18n.translate('expressionXY.legend.filterOutValueButtonAriaLabel', {
        defaultMessage: 'Filter out'
      }),
      'data-test-subj': `legend-${label}-filterOut`,
      iconType: 'minusInCircle',
      execute: () => {
        setPopoverOpen(false);
        onFilter({
          negate: true
        });
      }
    }];
    const allActions = [...(!hasFilterCellAction(legendCellValueActions) ? defaultFilterActions : []), ...legendCellValueActions];
    const legendCellValueActionPanelItems = allActions.map(action => ({
      name: action.displayName,
      'data-test-subj': `legend-${label}-${action.id}`,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: action.iconType,
        size: "m"
      }),
      onClick: () => {
        action.execute();
        setPopoverOpen(false);
      }
    }));
    return [{
      id: 'main',
      title: label,
      items: legendCellValueActionPanelItems
    }];
  }, [label, legendCellValueActions, onFilter]);
  const Button = /*#__PURE__*/_react.default.createElement("div", {
    tabIndex: 0,
    ref: ref,
    role: "button",
    "aria-pressed": "false",
    style: {
      display: 'flex',
      justifyContent: 'center',
      alignItems: 'center',
      height: '100%',
      marginLeft: 4,
      marginRight: 4
    },
    "data-test-subj": `legend-${label}`,
    onKeyPress: () => setPopoverOpen(!popoverOpen),
    onClick: () => setPopoverOpen(!popoverOpen),
    "aria-label": _i18n.i18n.translate('expressionXY.legend.legendActionsAria', {
      defaultMessage: 'Legend actions'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    type: "boxesVertical"
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: Button,
    isOpen: popoverOpen,
    closePopover: () => {
      setPopoverOpen(false);
      onClose();
    },
    panelPaddingSize: "none",
    anchorPosition: "upLeft",
    title: _i18n.i18n.translate('expressionXY.legend.filterOptionsLegend', {
      defaultMessage: '{legendDataLabel}, filter options',
      values: {
        legendDataLabel: label
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: "main",
    panels: panels
  }));
};
exports.LegendActionPopover = LegendActionPopover;