"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DebugComponent;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/presentation-util-plugin/public");
var _ = require(".");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const Debug = (0, _public.withSuspense)(_.LazyDebugComponent);
function DebugComponent({
  onLoaded,
  parentNode,
  payload
}) {
  const parentNodeDimensions = (0, _eui.useResizeObserver)(parentNode);
  const [dimensions, setDimensions] = (0, _react.useState)({
    width: parentNode.offsetWidth,
    height: parentNode.offsetHeight
  });
  const updateDebugView = (0, _react.useCallback)(() => {
    setDimensions({
      width: parentNode.offsetWidth,
      height: parentNode.offsetHeight
    });
    onLoaded();
  }, [parentNode, onLoaded]);
  (0, _react.useEffect)(() => {
    updateDebugView();
  }, [parentNodeDimensions, updateDebugView]);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: dimensions
  }, /*#__PURE__*/_react.default.createElement(Debug, {
    payload: payload
  }));
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;