"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterValueButton = FilterValueButton;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _use_app_data_view = require("../../hooks/use_app_data_view");
var _use_series_filters = require("../../hooks/use_series_filters");
var _field_value_suggestions = _interopRequireDefault(require("../../../field_value_suggestions"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FilterValueButton({
  isNestedOpen,
  setIsNestedOpen,
  value,
  field,
  negate,
  seriesId,
  series,
  nestedField,
  allSelectedValues
}) {
  var _dataViews$series$dat;
  const {
    dataViews
  } = (0, _use_app_data_view.useAppDataViewContext)(series.dataType);
  const {
    setFilter,
    removeFilter
  } = (0, _use_series_filters.useSeriesFilters)({
    seriesId,
    series
  });
  const hasActiveFilters = (allSelectedValues !== null && allSelectedValues !== void 0 ? allSelectedValues : []).includes(value);
  const button = /*#__PURE__*/_react.default.createElement(FilterButton, {
    hasActiveFilters: hasActiveFilters,
    color: negate ? 'danger' : 'primary',
    onClick: () => {
      if (hasActiveFilters) {
        removeFilter({
          field,
          value,
          negate
        });
      } else {
        setFilter({
          field,
          value,
          negate
        });
      }
      if (!hasActiveFilters) {
        setIsNestedOpen({
          value,
          negate
        });
      } else {
        setIsNestedOpen({
          value: '',
          negate
        });
      }
    }
  }, negate ? _i18n.i18n.translate('xpack.exploratoryView.expView.filterValueButton.negate', {
    defaultMessage: 'Not {value}',
    values: {
      value
    }
  }) : value);
  const onNestedChange = valuesN => {
    (valuesN !== null && valuesN !== void 0 ? valuesN : []).forEach(valN => {
      setFilter({
        field: nestedField,
        value: valN
      });
    });
    setIsNestedOpen({
      value: '',
      negate
    });
  };
  const forceOpenNested = (isNestedOpen === null || isNestedOpen === void 0 ? void 0 : isNestedOpen.value) === value && isNestedOpen.negate === negate;
  const filters = (0, _react.useMemo)(() => {
    return [{
      term: {
        [field]: value
      }
    }];
  }, [field, value]);
  return nestedField && forceOpenNested ? /*#__PURE__*/_react.default.createElement(_field_value_suggestions.default, {
    button: button,
    label: 'Version',
    sourceField: nestedField,
    onChange: onNestedChange,
    filters: filters,
    forceOpen: forceOpenNested,
    anchorPosition: "rightCenter",
    time: series.time,
    asCombobox: false,
    dataViewTitle: (_dataViews$series$dat = dataViews[series.dataType]) === null || _dataViews$series$dat === void 0 ? void 0 : _dataViews$series$dat.title
  }) : button;
}
const FilterButton = (0, _common.euiStyled)(_eui.EuiFilterButton)`
  background-color: rgba(${props => {
  const color = props.hasActiveFilters ? props.color === 'danger' ? (0, _eui.hexToRgb)(props.theme.eui.euiColorDanger) : (0, _eui.hexToRgb)(props.theme.eui.euiColorPrimary) : 'initial';
  return `${color[0]}, ${color[1]}, ${color[2]}, 0.1`;
}});
`;