"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFiltersFromDefs = void 0;
exports.getLayerConfigs = getLayerConfigs;
exports.useLensAttributes = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _public = require("@kbn/observability-shared-plugin/public");
var _heatmap_attributes = require("../configurations/lens_attributes/heatmap_attributes");
var _use_lens_formula_helper = require("./use_lens_formula_helper");
var _url_constants = require("../configurations/constants/url_constants");
var _lens_attributes = require("../configurations/lens_attributes");
var _use_series_storage = require("./use_series_storage");
var _default_configs = require("../configurations/default_configs");
var _use_app_data_view = require("./use_app_data_view");
var _constants = require("../configurations/constants");
var _exploratory_view_config = require("../contexts/exploratory_view_config");
var _single_metric_attributes = require("../configurations/lens_attributes/single_metric_attributes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFiltersFromDefs = reportDefinitions => {
  return Object.entries(reportDefinitions !== null && reportDefinitions !== void 0 ? reportDefinitions : {}).map(([field, value]) => {
    return {
      field,
      values: Array.isArray(value) ? value : [value]
    };
  }).filter(({
    values
  }) => !values.includes(_url_constants.ALL_VALUES_SELECTED));
};
exports.getFiltersFromDefs = getFiltersFromDefs;
function getLayerConfigs(allSeries, reportType, theme, dataViews, reportConfigMap, spaceId) {
  const layerConfigs = [];
  allSeries.forEach((series, seriesIndex) => {
    const dataView = dataViews === null || dataViews === void 0 ? void 0 : dataViews[series === null || series === void 0 ? void 0 : series.dataType];
    if (dataView && !(0, _lodash.isEmpty)(series.reportDefinitions) && !series.hidden && series.selectedMetricField) {
      var _series$filters, _theme$eui, _series$reportDefinit;
      const seriesConfig = (0, _default_configs.getDefaultConfigs)({
        reportType,
        dataView,
        dataType: series.dataType,
        reportConfigMap,
        spaceId
      });
      const filters = ((_series$filters = series.filters) !== null && _series$filters !== void 0 ? _series$filters : []).concat(getFiltersFromDefs(series.reportDefinitions), getFiltersFromDefs(series.textReportDefinitions));
      const color = (_theme$eui = theme.eui) === null || _theme$eui === void 0 ? void 0 : _theme$eui[`euiColorVis${seriesIndex}`];
      let seriesColor = series.color;
      if (reportType !== 'single-metric') {
        var _series$color;
        seriesColor = (_series$color = series.color) !== null && _series$color !== void 0 ? _series$color : color;
      }
      layerConfigs.push({
        filters,
        dataView,
        seriesConfig,
        time: series.time,
        name: series.name,
        color: seriesColor,
        breakdown: series.breakdown === _constants.LABEL_FIELDS_BREAKDOWN ? undefined : series.breakdown,
        seriesType: series.seriesType,
        operationType: series.operationType,
        reportDefinitions: (_series$reportDefinit = series.reportDefinitions) !== null && _series$reportDefinit !== void 0 ? _series$reportDefinit : {},
        selectedMetricField: series.selectedMetricField,
        showPercentileAnnotations: series.showPercentileAnnotations
      });
    }
  });
  return layerConfigs;
}
const useLensAttributes = () => {
  const {
    storage,
    allSeries,
    lastRefresh,
    reportType
  } = (0, _use_series_storage.useSeriesStorage)();
  const {
    dataViews
  } = (0, _use_app_data_view.useAppDataViewContext)();
  const spaceId = (0, _public.useKibanaSpace)();
  const {
    reportConfigMap
  } = (0, _exploratory_view_config.useExploratoryView)();
  const theme = (0, _public.useTheme)();
  const lensFormulaHelper = (0, _use_lens_formula_helper.useLensFormulaHelper)();
  return (0, _react.useMemo)(() => {
    var _storage$get, _spaceId$space;
    // we only use the data from url to apply, since that gets updated to apply changes
    const allSeriesT = (0, _use_series_storage.convertAllShortSeries)((_storage$get = storage.get(_use_series_storage.allSeriesKey)) !== null && _storage$get !== void 0 ? _storage$get : []);
    const reportTypeT = storage.get(_use_series_storage.reportTypeKey);
    if ((0, _lodash.isEmpty)(dataViews) || (0, _lodash.isEmpty)(allSeriesT) || !reportTypeT || !lensFormulaHelper) {
      return null;
    }
    const layerConfigs = getLayerConfigs(allSeriesT, reportTypeT, theme, dataViews, reportConfigMap, (_spaceId$space = spaceId.space) === null || _spaceId$space === void 0 ? void 0 : _spaceId$space.id);
    if (layerConfigs.length < 1) {
      return null;
    }
    if (reportTypeT === 'single-metric') {
      const lensAttributes = new _single_metric_attributes.SingleMetricLensAttributes(layerConfigs, reportTypeT, lensFormulaHelper);
      return lensAttributes.getJSON('lnsLegacyMetric', lastRefresh);
    }
    if (reportTypeT === 'heatmap') {
      const lensAttributes = new _heatmap_attributes.HeatMapLensAttributes(layerConfigs, reportTypeT, lensFormulaHelper);
      return lensAttributes.getJSON('lnsHeatmap', lastRefresh);
    }
    const lensAttributes = new _lens_attributes.LensAttributes(layerConfigs, reportTypeT, lensFormulaHelper);
    return lensAttributes.getJSON('lnsXY', lastRefresh);
    // we also want to check the state on allSeries changes
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dataViews, reportType, storage, theme, lastRefresh, allSeries, lensFormulaHelper]);
};
exports.useLensAttributes = useLensAttributes;