"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewContext = void 0;
exports.DataViewContextProvider = DataViewContextProvider;
exports.useAppDataViewContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/data-views-plugin/common");
var _observability_data_views = require("../../../../utils/observability_data_views");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataViewContext = /*#__PURE__*/(0, _react.createContext)({});
exports.DataViewContext = DataViewContext;
function DataViewContextProvider({
  children
}) {
  const [loading, setLoading] = (0, _react.useState)({});
  const [dataViews, setDataViews] = (0, _react.useState)({});
  const [dataViewErrors, setDataViewErrors] = (0, _react.useState)({});
  const [hasAppData, setHasAppData] = (0, _react.useState)({});
  const {
    services: {
      dataViews: dataViewsService
    }
  } = (0, _public.useKibana)();
  const loadDataView = (0, _react.useCallback)(async ({
    dataType
  }) => {
    if (typeof hasAppData[dataType] === 'undefined' && !loading[dataType]) {
      setLoading(prevState => ({
        ...prevState,
        [dataType]: true
      }));
      try {
        const {
          indices,
          hasData
        } = await (0, _observability_data_views.getDataTypeIndices)(dataType);
        setHasAppData(prevState => ({
          ...prevState,
          [dataType]: hasData
        }));
        if (hasData && indices) {
          const obsvDataV = new _observability_data_views.ObservabilityDataViews(dataViewsService, true);
          const dataV = await obsvDataV.getDataView(dataType, indices);
          setDataViews(prevState => ({
            ...prevState,
            [dataType]: dataV
          }));
        }
        setLoading(prevState => ({
          ...prevState,
          [dataType]: false
        }));
      } catch (e) {
        if (e instanceof _common.DataViewInsufficientAccessError || e.body === 'Forbidden') {
          setDataViewErrors(prevState => ({
            ...prevState,
            [dataType]: e
          }));
        }
        setLoading(prevState => ({
          ...prevState,
          [dataType]: false
        }));
      }
    }
  }, [dataViewsService, hasAppData, loading]);
  return /*#__PURE__*/_react.default.createElement(DataViewContext.Provider, {
    value: {
      hasAppData,
      dataViews,
      loadDataView,
      dataViewErrors,
      loading: !!Object.values(loading).find(loadingT => loadingT)
    }
  }, children);
}
const useAppDataViewContext = dataType => {
  const {
    loading,
    hasAppData,
    loadDataView,
    dataViews,
    dataViewErrors
  } = (0, _react.useContext)(DataViewContext);
  if (dataType && !(dataViews !== null && dataViews !== void 0 && dataViews[dataType]) && !loading) {
    loadDataView({
      dataType
    });
  }
  return (0, _react.useMemo)(() => {
    return {
      hasAppData,
      loading,
      dataViews,
      dataViewErrors,
      dataView: dataType ? dataViews === null || dataViews === void 0 ? void 0 : dataViews[dataType] : undefined,
      hasData: dataType ? hasAppData === null || hasAppData === void 0 ? void 0 : hasAppData[dataType] : undefined,
      loadDataView
    };
  }, [dataType, hasAppData, dataViewErrors, dataViews, loadDataView, loading]);
};
exports.useAppDataViewContext = useAppDataViewContext;