"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/core/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _public3 = require("@kbn/kibana-utils-plugin/public");
var _plugin_context = require("../context/plugin_context");
var _routes = require("../routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function App() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, Object.keys(_routes.routes).map(key => {
    const path = key;
    const {
      handler,
      exact
    } = _routes.routes[path];
    const Wrapper = () => {
      return handler();
    };
    return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      key: path,
      path: path,
      exact: exact,
      component: Wrapper
    });
  })));
}
const renderApp = ({
  core,
  appMountParameters,
  plugins,
  usageCollection,
  isDev
}) => {
  var _usageCollection$comp;
  const {
    element,
    history,
    theme$
  } = appMountParameters;
  const i18nCore = core.i18n;
  const isDarkMode = core.uiSettings.get('theme:darkMode');
  core.chrome.setHelpExtension({
    appName: _i18n.i18n.translate('xpack.exploratoryView.feedbackMenu.appName', {
      defaultMessage: 'Observability'
    }),
    links: [{
      linkType: 'discuss',
      href: 'https://ela.st/observability-discuss'
    }]
  });

  // ensure all divs are .kbnAppWrappers
  element.classList.add(_public.APP_WRAPPER_CLASS);
  const ApplicationUsageTrackingProvider = (_usageCollection$comp = usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.components.ApplicationUsageTrackingProvider) !== null && _usageCollection$comp !== void 0 ? _usageCollection$comp : _react.default.Fragment;
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(ApplicationUsageTrackingProvider, null, /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins,
      storage: new _public3.Storage(localStorage),
      isDev
    }
  }, /*#__PURE__*/_react.default.createElement(_plugin_context.PluginContext.Provider, {
    value: {
      appMountParameters
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: isDarkMode
  }, /*#__PURE__*/_react.default.createElement(i18nCore.Context, null, /*#__PURE__*/_react.default.createElement("div", {
    className: _public.APP_WRAPPER_CLASS,
    "data-test-subj": "exploratoryViewMainContainer"
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application: core.application
    }
  }, /*#__PURE__*/_react.default.createElement(App, null))))))))))), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;