"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventAnnotationListingPlugin = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
/** @public */

/** @public */
class EventAnnotationListingPlugin {
  setup(core, dependencies) {
    dependencies.visualizations.listingViewRegistry.add({
      title: _i18n.i18n.translate('eventAnnotationListing.listingViewTitle', {
        defaultMessage: 'Annotation groups'
      }),
      id: 'annotations',
      getTableList: async props => {
        const [coreStart, pluginsStart] = await core.getStartServices();
        const eventAnnotationService = await pluginsStart.eventAnnotation.getService();
        const ids = await pluginsStart.dataViews.getIds();
        const dataViews = await Promise.all(ids.map(id => pluginsStart.dataViews.get(id)));
        const services = {
          core: coreStart,
          LensEmbeddableComponent: pluginsStart.lens.EmbeddableComponent,
          savedObjectsTagging: pluginsStart.savedObjectsTagging,
          eventAnnotationService,
          PresentationUtilContextProvider: pluginsStart.presentationUtil.ContextProvider,
          dataViews,
          createDataView: pluginsStart.dataViews.create.bind(pluginsStart.dataViews),
          sessionService: pluginsStart.data.search.session,
          queryInputServices: {
            http: coreStart.http,
            docLinks: coreStart.docLinks,
            notifications: coreStart.notifications,
            uiSettings: coreStart.uiSettings,
            dataViews: pluginsStart.dataViews,
            unifiedSearch: pluginsStart.unifiedSearch,
            data: pluginsStart.data,
            storage: new _public.Storage(localStorage)
          }
        };
        const {
          getTableList
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./get_table_list')));
        return getTableList(props, services);
      }
    });
  }
  start(core, plugins) {
    // nothing to do here
  }
}
exports.EventAnnotationListingPlugin = EventAnnotationListingPlugin;