"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KQL_NODE_TYPE_FUNCTION = void 0;
exports.buildNode = buildNode;
exports.buildNodeWithArgumentNodes = buildNodeWithArgumentNodes;
exports.isNode = isNode;
exports.toElasticsearchQuery = toElasticsearchQuery;
exports.toKqlExpression = toKqlExpression;
var _lodash = _interopRequireDefault(require("lodash"));
var _functions = require("../functions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const KQL_NODE_TYPE_FUNCTION = 'function';
exports.KQL_NODE_TYPE_FUNCTION = KQL_NODE_TYPE_FUNCTION;
function isNode(node) {
  return node.type === KQL_NODE_TYPE_FUNCTION;
}
function buildNode(functionName, ...args) {
  const kueryFunction = _functions.functions[functionName];
  if (_lodash.default.isUndefined(kueryFunction)) {
    throw new Error(`Unknown function "${functionName}"`);
  }
  return {
    type: KQL_NODE_TYPE_FUNCTION,
    function: functionName,
    // This requires better typing of the different typings and their return types.
    // @ts-ignore
    ...kueryFunction.buildNodeParams(...args)
  };
}

// Mainly only useful in the grammar where we'll already have real argument nodes in hand
function buildNodeWithArgumentNodes(functionName, args) {
  if (_lodash.default.isUndefined(_functions.functions[functionName])) {
    throw new Error(`Unknown function "${functionName}"`);
  }
  return {
    type: KQL_NODE_TYPE_FUNCTION,
    function: functionName,
    arguments: args
  };
}
function toElasticsearchQuery(node, indexPattern, config, context) {
  if (_functions.functions.and.isNode(node)) return _functions.functions.and.toElasticsearchQuery(node, indexPattern, config, context);
  if (_functions.functions.exists.isNode(node)) return _functions.functions.exists.toElasticsearchQuery(node), indexPattern, config, context;
  if (_functions.functions.is.isNode(node)) return _functions.functions.is.toElasticsearchQuery(node, indexPattern, config, context);
  if (_functions.functions.nested.isNode(node)) return _functions.functions.nested.toElasticsearchQuery(node, indexPattern, config, context);
  if (_functions.functions.not.isNode(node)) return _functions.functions.not.toElasticsearchQuery(node, indexPattern, config, context);
  if (_functions.functions.or.isNode(node)) return _functions.functions.or.toElasticsearchQuery(node, indexPattern, config, context);
  if (_functions.functions.range.isNode(node)) return _functions.functions.range.toElasticsearchQuery(node, indexPattern, config, context);
  throw new Error(`Unknown KQL function: "${node.function}"`);
}
function toKqlExpression(node) {
  if (_functions.functions.and.isNode(node)) return _functions.functions.and.toKqlExpression(node);
  if (_functions.functions.exists.isNode(node)) return _functions.functions.exists.toKqlExpression(node);
  if (_functions.functions.is.isNode(node)) return _functions.functions.is.toKqlExpression(node);
  if (_functions.functions.nested.isNode(node)) return _functions.functions.nested.toKqlExpression(node);
  if (_functions.functions.not.isNode(node)) return _functions.functions.not.toKqlExpression(node);
  if (_functions.functions.or.isNode(node)) return _functions.functions.or.toKqlExpression(node);
  if (_functions.functions.range.isNode(node)) return _functions.functions.range.toKqlExpression(node);
  throw new Error(`Unknown KQL function: "${node.function}"`);
}