"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KQL_FUNCTION_EXISTS = void 0;
exports.buildNodeParams = buildNodeParams;
exports.isNode = isNode;
exports.toElasticsearchQuery = toElasticsearchQuery;
exports.toKqlExpression = toKqlExpression;
var _literal = require("../node_types/literal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const KQL_FUNCTION_EXISTS = 'exists';
exports.KQL_FUNCTION_EXISTS = KQL_FUNCTION_EXISTS;
function isNode(node) {
  return node.function === KQL_FUNCTION_EXISTS;
}
function buildNodeParams(fieldName) {
  return {
    arguments: [(0, _literal.buildNode)(fieldName)]
  };
}
function toElasticsearchQuery(node, indexPattern, config = {}, context = {}) {
  var _indexPattern$fields;
  const {
    arguments: [fieldNameArg]
  } = node;
  const fullFieldNameArg = {
    ...fieldNameArg,
    value: context !== null && context !== void 0 && context.nested ? `${context.nested.path}.${fieldNameArg.value}` : fieldNameArg.value
  };
  const fieldName = (0, _literal.toElasticsearchQuery)(fullFieldNameArg);
  const field = indexPattern === null || indexPattern === void 0 ? void 0 : (_indexPattern$fields = indexPattern.fields) === null || _indexPattern$fields === void 0 ? void 0 : _indexPattern$fields.find(fld => fld.name === fieldName);
  if (field !== null && field !== void 0 && field.scripted) {
    throw new Error(`Exists query does not support scripted fields`);
  }
  return {
    exists: {
      field: fieldName
    }
  };
}
function toKqlExpression(node) {
  const [field] = node.arguments;
  return `${(0, _literal.toKqlExpression)(field)}: *`;
}