"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _app_logic = require("../../app_logic");
var _layout = require("../../components/layout");
var _gated_form_page = require("./gated_form_page");
var _onboarding_steps = require("./onboarding_steps");
var _organization_stats = require("./organization_stats");
var _overview_logic = require("./overview_logic");
var _recent_activity = require("./recent_activity");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ONBOARDING_HEADER_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.overviewOnboardingHeader.title', {
  defaultMessage: 'Get started with Workplace Search'
});
const HEADER_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.overviewHeader.title', {
  defaultMessage: 'Organization overview'
});
const ONBOARDING_HEADER_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.overviewOnboardingHeader.description', {
  defaultMessage: 'Complete the following to set up your organization.'
});
const HEADER_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.overviewHeader.description', {
  defaultMessage: "Your organizations's statistics and activity"
});
const Overview = () => {
  const {
    organization: {
      name: orgName,
      defaultOrgName,
      kibanaUIsEnabled
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    initializeOverview
  } = (0, _kea.useActions)(_overview_logic.OverviewLogic);
  const {
    dataLoading,
    hasUsers,
    hasOrgSources,
    isOldAccount
  } = (0, _kea.useValues)(_overview_logic.OverviewLogic);
  (0, _react.useEffect)(() => {
    initializeOverview();
  }, [initializeOverview]);
  const hideOnboarding = hasUsers && hasOrgSources && isOldAccount && orgName !== defaultOrgName;
  const headerTitle = hideOnboarding ? HEADER_TITLE : ONBOARDING_HEADER_TITLE;
  const headerDescription = hideOnboarding ? HEADER_DESCRIPTION : ONBOARDING_HEADER_DESCRIPTION;
  return kibanaUIsEnabled ? /*#__PURE__*/_react.default.createElement(_layout.WorkplaceSearchPageTemplate, {
    pageChrome: [],
    pageHeader: dataLoading ? undefined : {
      pageTitle: headerTitle,
      description: headerDescription
    },
    pageViewTelemetry: "overview",
    isLoading: dataLoading
  }, !hideOnboarding && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_onboarding_steps.OnboardingSteps, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_organization_stats.OrganizationStats, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_recent_activity.RecentActivity, null)) : /*#__PURE__*/_react.default.createElement(_gated_form_page.WorkplaceSearchGatePage, {
    isLoading: dataLoading
  });
};
exports.Overview = Overview;