"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupSourcePrioritization = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../shared/constants");
var _layout = require("../../../components/layout");
var _source_icon = require("../../../components/shared/source_icon");
var _constants2 = require("../../../constants");
var _group_logic = require("../group_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HEADER_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.sourceProioritization.headerTitle', {
  defaultMessage: 'Organizational content source prioritization'
});
const HEADER_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.sourceProioritization.headerDescription', {
  defaultMessage: 'Calibrate relative document importance across group content sources.'
});
const ZERO_STATE_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.sourceProioritization.zeroStateTitle', {
  defaultMessage: 'No sources are shared with this group'
});
const ZERO_STATE_BUTTON_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.sourceProioritization.zeroStateButtonText', {
  defaultMessage: 'Add organizational content sources'
});
const SOURCE_TABLE_HEADER = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.sourceProioritization.sourceTableHeader', {
  defaultMessage: 'Source'
});
const PRIORITY_TABLE_HEADER = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.sourceProioritization.priorityTableHeader', {
  defaultMessage: 'Relevance Priority'
});
const GroupSourcePrioritization = () => {
  const {
    updatePriority,
    saveGroupSourcePrioritization,
    showOrgSourcesModal
  } = (0, _kea.useActions)(_group_logic.GroupLogic);
  const {
    group: {
      contentSources = [],
      name: groupName
    },
    dataLoading,
    activeSourcePriorities,
    groupPrioritiesUnchanged
  } = (0, _kea.useValues)(_group_logic.GroupLogic);
  const headerAction = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: groupPrioritiesUnchanged,
    color: "primary",
    fill: true,
    onClick: saveGroupSourcePrioritization
  }, _constants.SAVE_BUTTON_LABEL);
  const handleSliderChange = (id, e) => updatePriority(id, Number(e.currentTarget.value));
  const hasSources = contentSources.length > 0;
  const zeroState = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "advancedSettingsApp",
    iconColor: "subdued",
    titleSize: "s",
    title: /*#__PURE__*/_react.default.createElement("h3", null, ZERO_STATE_TITLE),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.sourceProioritization.zeroStateBody', {
      defaultMessage: 'Share two or more sources with {groupName} to customize source prioritization.',
      values: {
        groupName
      }
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: showOrgSourcesModal
    }, ZERO_STATE_BUTTON_TEXT)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }));
  const sourceTable = /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    responsive: false,
    tableLayout: "auto"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, null, SOURCE_TABLE_HEADER), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    align: "right"
  }, PRIORITY_TABLE_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, contentSources.map(({
    id,
    name,
    serviceType
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    key: id,
    "data-test-subj": "GroupsRow"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_source_icon.SourceIcon, {
    serviceType: serviceType,
    name: name
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, name))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    align: "right"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    id: id,
    min: 1,
    max: 10,
    step: 1,
    showInput: true,
    value: activeSourcePriorities[id],
    onChange: e => handleSliderChange(id, e)
  }))))))));
  return /*#__PURE__*/_react.default.createElement(_layout.WorkplaceSearchPageTemplate, {
    pageChrome: [_constants2.NAV.GROUPS, groupName || '...', _constants2.NAV.SOURCE_PRIORITIZATION],
    pageViewTelemetry: "group_overview",
    pageHeader: {
      pageTitle: HEADER_TITLE,
      description: HEADER_DESCRIPTION,
      rightSideItems: [headerAction]
    },
    isLoading: dataLoading
  }, hasSources ? sourceTable : zeroState);
};
exports.GroupSourcePrioritization = GroupSourcePrioritization;