"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NO_SOURCES_MESSAGE = exports.GroupRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../shared/constants");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _truncate = require("../../../../shared/truncate");
var _routes = require("../../../routes");
var _group_logic = require("../group_logic");
var _group_sources = require("./group_sources");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DAYS_CUTOFF = 8;
const NO_SOURCES_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.noSourcesMessage', {
  defaultMessage: 'No organizational content sources'
});
exports.NO_SOURCES_MESSAGE = NO_SOURCES_MESSAGE;
const dateDisplay = date => (0, _moment.default)(date).isAfter((0, _moment.default)().subtract(DAYS_CUTOFF, 'days')) ? (0, _moment.default)(date).fromNow() : (0, _moment.default)(date).format('MMMM D, YYYY');
const GroupRow = ({
  id,
  name,
  updatedAt,
  contentSources
}) => {
  const GROUP_UPDATED_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.groupUpdatedText', {
    defaultMessage: 'Last updated {updatedAt}.',
    values: {
      updatedAt: dateDisplay(updatedAt)
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    "data-test-subj": "GroupsRow"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    to: (0, _routes.getGroupPath)(id)
  }, /*#__PURE__*/_react.default.createElement(_truncate.TruncatedContent, {
    tooltipType: "title",
    content: name,
    length: _group_logic.MAX_NAME_LENGTH
  }))), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("small", null, GROUP_UPDATED_TEXT)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "user-group__sources"
  }, contentSources.length > 0 ? /*#__PURE__*/_react.default.createElement(_group_sources.GroupSources, {
    groupSources: contentSources
  }) : NO_SOURCES_MESSAGE)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    align: "right"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    "aria-label": _constants.MANAGE_BUTTON_LABEL,
    to: (0, _routes.getGroupPath)(id)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "pencil"
  })))));
};
exports.GroupRow = GroupRow;