"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivateSources = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _licensing = require("../../../shared/licensing");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _app_logic = require("../../app_logic");
var _share_circle = _interopRequireDefault(require("../../assets/share_circle.svg"));
var _layout = require("../../components/layout");
var _content_section = require("../../components/shared/content_section");
var _sources_table = require("../../components/shared/sources_table");
var _constants = require("../../constants");
var _routes = require("../../routes");
var _utils = require("../../utils");
var _constants2 = require("./constants");
var _sources_logic = require("./sources_logic");
var _sources_view = require("./sources_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrivateSources = () => {
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const {
    initializeSources,
    setSourceSearchability,
    resetSourcesState
  } = (0, _kea.useActions)(_sources_logic.SourcesLogic);
  (0, _react.useEffect)(() => {
    initializeSources();
    return resetSourcesState;
  }, []);
  const {
    dataLoading,
    contentSources,
    serviceTypes,
    privateContentSources
  } = (0, _kea.useValues)(_sources_logic.SourcesLogic);
  const {
    account: {
      canCreatePrivateSources,
      groups
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const hasConfiguredConnectors = serviceTypes.some(({
    configured
  }) => configured);
  const canAddSources = canCreatePrivateSources && hasConfiguredConnectors;
  const hasPrivateSources = (privateContentSources === null || privateContentSources === void 0 ? void 0 : privateContentSources.length) > 0;
  const hasOrgSources = contentSources.length > 0;
  const licenseCallout = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _constants2.LICENSE_CALLOUT_TITLE,
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement("p", null, _constants2.LICENSE_CALLOUT_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  const headerAction = /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    to: (0, _routes.getSourcesPath)(_routes.ADD_SOURCE_PATH, false),
    fill: true,
    color: "primary",
    "data-test-subj": "AddSourceButton"
  }, _constants2.PRIVATE_LINK_TITLE);
  const privateSourcesEmptyState = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "lock",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _constants2.PRIVATE_EMPTY_TITLE)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }));
  const privateSourcesTable = /*#__PURE__*/_react.default.createElement(_sources_table.SourcesTable, {
    showDetails: true,
    onSearchableToggle: setSourceSearchability,
    sources: privateContentSources
  });
  const privateSourcesSection = /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, {
    isOrganization: false,
    title: _constants2.PRIVATE_HEADER_TITLE,
    description: _constants2.PRIVATE_HEADER_DESCRIPTION,
    action: canAddSources && headerAction
  }, hasPrivateSources ? privateSourcesTable : privateSourcesEmptyState);
  const orgSourcesEmptyState = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: _share_circle.default,
    title: /*#__PURE__*/_react.default.createElement("h2", null, _constants2.ORG_SOURCES_EMPTY_TITLE),
    body: /*#__PURE__*/_react.default.createElement("p", null, _constants2.ORG_SOURCES_EMPTY_DESCRIPTION)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }));
  const orgSourcesTable = /*#__PURE__*/_react.default.createElement(_sources_table.SourcesTable, {
    showDetails: false,
    isOrganization: false,
    sources: contentSources
  });
  const orgSourcesSection = /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, {
    isOrganization: false,
    title: _constants2.PRIVATE_ORG_SOURCES_TITLE,
    description: hasOrgSources && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.workplaceSearch.sources.private.privateOrg.header.description",
      defaultMessage: "You have access to the following sources through {newline}the {groups, plural, one {group} other {groups}} {groupsSentence}.",
      values: {
        groups: groups.length,
        groupsSentence: (0, _utils.toSentenceSerial)(groups),
        newline: /*#__PURE__*/_react.default.createElement("br", null)
      }
    })
  }, hasOrgSources ? orgSourcesTable : orgSourcesEmptyState);
  return /*#__PURE__*/_react.default.createElement(_layout.PersonalDashboardLayout, {
    pageChrome: [_constants.NAV.SOURCES],
    isLoading: dataLoading
  }, /*#__PURE__*/_react.default.createElement(_sources_view.SourcesView, null, hasPrivateSources && !hasPlatinumLicense && licenseCallout, canCreatePrivateSources && privateSourcesSection, orgSourcesSection));
};
exports.PrivateSources = PrivateSources;