"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Synchronization = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _doc_links = require("../../../../../shared/doc_links");
var _view_content_header = require("../../../../components/shared/view_content_header");
var _constants = require("../../../../constants");
var _constants2 = require("../../constants");
var _source_logic = require("../../source_logic");
var _source_layout = require("../source_layout");
var _synchronization_logic = require("./synchronization_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Synchronization = () => {
  const {
    contentSource
  } = (0, _kea.useValues)(_source_logic.SourceLogic);
  const {
    updateSyncEnabled
  } = (0, _kea.useActions)((0, _synchronization_logic.SynchronizationLogic)({
    contentSource
  }));
  const {
    isSyncConfigEnabled,
    indexing: {
      enabled
    }
  } = contentSource;
  const onChange = checked => updateSyncEnabled(checked);
  const syncToggle = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _constants2.SOURCE_SYNCHRONIZATION_TOGGLE_LABEL,
    checked: enabled,
    onChange: e => onChange(e.target.checked)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, _constants2.SOURCE_SYNCHRONIZATION_TOGGLE_DESCRIPTION));
  const syncDisabledCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _constants2.SYNCHRONIZATION_DISABLED_TITLE,
    color: "warning",
    iconType: "help"
  }, /*#__PURE__*/_react.default.createElement("p", null, _constants2.SYNCHRONIZATION_DISABLED_DESCRIPTION));
  return /*#__PURE__*/_react.default.createElement(_source_layout.SourceLayout, {
    pageChrome: [_constants.NAV.SYNCHRONIZATION],
    pageViewTelemetry: "source_synchronization",
    isLoading: false
  }, /*#__PURE__*/_react.default.createElement(_view_content_header.ViewContentHeader, {
    title: _constants.NAV.SYNCHRONIZATION,
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _constants2.SOURCE_SYNCHRONIZATION_DESCRIPTION, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _doc_links.docLinks.workplaceSearchSynch,
      external: true
    }, _constants2.LEARN_MORE_LINK))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), isSyncConfigEnabled ? syncToggle : syncDisabledCallout);
};
exports.Synchronization = Synchronization;