"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FrequencyItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../shared/constants");
var _constants2 = require("../../constants");
var _source_logic = require("../../source_logic");
var _synchronization_logic = require("./synchronization_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FrequencyItem = ({
  type,
  label,
  description,
  duration,
  estimate
}) => {
  const {
    contentSource
  } = (0, _kea.useValues)(_source_logic.SourceLogic);
  const {
    setSyncFrequency
  } = (0, _kea.useActions)((0, _synchronization_logic.SynchronizationLogic)({
    contentSource
  }));
  const {
    lastRun,
    nextStart,
    duration: durationEstimate
  } = estimate;
  const estimateDisplay = durationEstimate && _moment.default.duration(durationEstimate).humanize();
  const nextStartIsPast = (0, _moment.default)().isAfter(nextStart);
  const nextStartTime = nextStartIsPast ? _constants2.NEXT_SYNC_RUNNING_MESSAGE : (0, _moment.default)(nextStart).fromNow();
  const showEstimates = lastRun || nextStart || durationEstimate;
  const frequencyItemLabel = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSources.synchronization.frequencyItemLabel",
    defaultMessage: "Perform a {label} every",
    values: {
      label: /*#__PURE__*/_react.default.createElement("strong", null, label)
    }
  });
  const lastRunSummary = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSources.synchronization.lastRunSummary",
    defaultMessage: "This sync {lastRunStrong} {lastRunTime}.",
    values: {
      lastRunStrong: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.workplaceSearch.contentSources.synchronization.lastRunLabel",
        defaultMessage: "last run"
      })),
      lastRunTime: (0, _moment.default)(lastRun).fromNow()
    }
  });
  const nextStartSummary = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "nextStartSummary",
    id: "xpack.enterpriseSearch.workplaceSearch.contentSources.synchronization.nextStartSummary",
    defaultMessage: "{nextStartStrong} will begin {nextStartTime}.",
    values: {
      nextStartStrong: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.workplaceSearch.contentSources.synchronization.nextStartLabel",
        defaultMessage: "Next run"
      })),
      nextStartTime
    }
  });
  const estimateSummary = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSources.synchronization.estimateSummaryLabel",
    defaultMessage: "Estimated to take {estimateDisplay} to complete.",
    values: {
      estimateDisplay
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, frequencyItemLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 120
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "durationDays",
    value: _moment.default.duration(duration).days(),
    append: _constants.DAYS_UNIT_LABEL,
    onChange: e => setSyncFrequency(type, e.target.value, 'days')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 120
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "durationHours",
    value: _moment.default.duration(duration).hours(),
    append: _constants.HOURS_UNIT_LABEL,
    onChange: e => setSyncFrequency(type, e.target.value, 'hours')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 150
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "durationMinutes",
    value: _moment.default.duration(duration).minutes(),
    append: _constants.MINUTES_UNIT_LABEL,
    onChange: e => setSyncFrequency(type, e.target.value, 'minutes')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    title: label,
    type: "iInCircle",
    content: description
  }))), showEstimates && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "SyncEstimates"
  }, lastRun && lastRunSummary, " ", nextStart && nextStartSummary, ' ', estimateDisplay && estimateSummary)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
};
exports.FrequencyItem = FrequencyItem;