"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handlePrivateKeyUpload = void 0;
var _read_uploaded_file_as_text = require("./read_uploaded_file_as_text");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const handlePrivateKeyUpload = async (files, callback) => {
  if (!files || files.length < 1) {
    return null;
  }
  const file = files[0];
  const text = await (0, _read_uploaded_file_as_text.readUploadedFileAsText)(file);
  callback(text);
};
exports.handlePrivateKeyUpload = handlePrivateKeyUpload;