"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PersonalDashboardLayout = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _ = require("..");
var _flash_messages = require("../../../../shared/flash_messages");
var _http = require("../../../../shared/http");
var _kibana_chrome = require("../../../../shared/kibana_chrome");
var _loading = require("../../../../shared/loading");
var _routes = require("../../../routes");
var _constants = require("../../../views/content_sources/constants");
require("./personal_dashboard_layout.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PersonalDashboardLayout = ({
  children,
  isLoading,
  pageChrome
}) => {
  const {
    readOnlyMode
  } = (0, _kea.useValues)(_http.HttpLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, pageChrome && /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetWorkplaceSearchChrome, {
    trail: pageChrome
  }), /*#__PURE__*/_react.default.createElement(_.AccountHeader, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    className: "personalDashboardLayout",
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSidebar, {
    role: "navigation",
    className: "personalDashboardLayout__sideBar",
    sticky: true,
    minWidth: "480px"
  }, (0, _reactRouterDom.useRouteMatch)(_routes.PRIVATE_SOURCES_PATH) && /*#__PURE__*/_react.default.createElement(_.PrivateSourcesSidebar, null), (0, _reactRouterDom.useRouteMatch)(_routes.PERSONAL_SETTINGS_PATH) && /*#__PURE__*/_react.default.createElement(_.AccountSettingsSidebar, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    component: "main",
    panelled: true,
    role: "main"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    className: "personalDashboardLayout__body",
    paddingSize: "none",
    restrictWidth: true
  }, readOnlyMode && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "lock",
    title: _constants.PERSONAL_DASHBOARD_READ_ONLY_MODE_WARNING
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_flash_messages.FlashMessages, null), isLoading ? /*#__PURE__*/_react.default.createElement(_loading.Loading, null) : children))));
};
exports.PersonalDashboardLayout = PersonalDashboardLayout;