"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DevToolsConsoleCodeBlock = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _lzString = require("lz-string");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../../shared/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DevToolsConsoleCodeBlock = ({
  children,
  ...props
}) => {
  var _application$capabili, _application$capabili2, _url$locators$get;
  const {
    application,
    share: {
      url
    }
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const consolePreviewLink = !!(application !== null && application !== void 0 && (_application$capabili = application.capabilities) !== null && _application$capabili !== void 0 && (_application$capabili2 = _application$capabili.dev_tools) !== null && _application$capabili2 !== void 0 && _application$capabili2.show) && ((_url$locators$get = url.locators.get('CONSOLE_APP_LOCATOR')) === null || _url$locators$get === void 0 ? void 0 : _url$locators$get.useUrl({
    loadFrom: `data:text/plain,${(0, _lzString.compressToEncodedURIComponent)(children)}`
  }, undefined, []));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: "dark"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "rowReverse",
    gutterSize: "s"
  }, consolePreviewLink && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "popout",
    color: "success",
    href: consolePreviewLink,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.component.devToolsConsoleCodeBlock.tryInConsole",
    defaultMessage: "Try in Console"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: children
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "copyClipboard",
    onClick: copy,
    color: "text"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.component.devToolsConsoleCodeBlock.copy",
    defaultMessage: "Copy"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, (0, _extends2.default)({
    paddingSize: "s",
    fontSize: "m",
    transparentBackground: true,
    color: "subduedText"
  }, props), children))));
};
exports.DevToolsConsoleCodeBlock = DevToolsConsoleCodeBlock;