"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnsavedChangesPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_MESSAGE_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.shared.unsavedChangesMessage', {
  defaultMessage: 'Your changes have not been saved. Are you sure you want to leave?'
});
const UnsavedChangesPrompt = ({
  hasUnsavedChanges,
  messageText = DEFAULT_MESSAGE_TEXT
}) => {
  (0, _react.useEffect)(() => {
    const handler = event => {
      if (hasUnsavedChanges) {
        // These 2 lines of code are the recommendation from MDN for triggering a browser prompt for confirming
        // whether or not a user wants to leave the current site.
        event.preventDefault();
        event.returnValue = '';
      }
    };
    // Adding this handler will prompt users if they are navigating to a new page, outside of the Kibana SPA
    window.addEventListener('beforeunload', handler);
    return () => window.removeEventListener('beforeunload', handler);
  }, [hasUnsavedChanges]);

  // Adding this Prompt will prompt users if they are navigating to a new page, within the Kibana SPA
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Prompt, {
    when: hasUnsavedChanges,
    message: messageText
  });
};
exports.UnsavedChangesPrompt = UnsavedChangesPrompt;