"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountKibanaLogic = exports.KibanaLogic = void 0;
var _kea = require("kea");
var _constants = require("@kbn/search-api-panels/constants");
var _http = require("../http");
var _react_router_helpers = require("../react_router_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KibanaLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'kibana_logic'],
  reducers: ({
    props
  }) => ({
    application: [props.application || {}, {}],
    capabilities: [props.capabilities || {}, {}],
    charts: [props.charts, {}],
    cloud: [props.cloud || {}, {}],
    config: [props.config || {}, {}],
    data: [props.data, {}],
    esConfig: [props.esConfig || {
      elasticsearch_host: _constants.ELASTICSEARCH_URL_PLACEHOLDER
    }, {}],
    guidedOnboarding: [props.guidedOnboarding, {}],
    history: [props.history, {}],
    isSidebarEnabled: [props.isSidebarEnabled, {}],
    lens: [props.lens, {}],
    ml: [props.ml, {}],
    navigateToUrl: [(url, options) => {
      const deps = {
        history: props.history,
        http: _http.HttpLogic.values.http
      };
      const href = (0, _react_router_helpers.createHref)(url, deps, options);
      return props.navigateToUrl(href);
    }, {}],
    productAccess: [props.productAccess, {}],
    productFeatures: [props.productFeatures, {}],
    renderHeaderActions: [props.renderHeaderActions, {}],
    security: [props.security, {}],
    setBreadcrumbs: [props.setBreadcrumbs, {}],
    setChromeIsVisible: [props.setChromeIsVisible, {}],
    setDocTitle: [props.setDocTitle, {}],
    share: [props.share, {}],
    uiSettings: [props.uiSettings, {}],
    user: [props.user, {}]
  }),
  selectors: ({
    selectors
  }) => ({
    isCloud: [() => [selectors.cloud], cloud => !!(cloud !== null && cloud !== void 0 && cloud.isCloudEnabled)]
  })
});
exports.KibanaLogic = KibanaLogic;
const mountKibanaLogic = props => {
  KibanaLogic(props);
  const unmount = KibanaLogic.mount();
  return unmount;
};
exports.mountKibanaLogic = mountKibanaLogic;