"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FLASH_MESSAGE_TYPES = exports.DEFAULT_TOAST_TIMEOUT = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FLASH_MESSAGE_TYPES = {
  success: {
    color: 'success',
    iconType: 'check'
  },
  info: {
    color: 'primary',
    iconType: 'iInCircle'
  },
  warning: {
    color: 'warning',
    iconType: 'warning'
  },
  error: {
    color: 'danger',
    iconType: 'error'
  }
};

// This is the default amount of time (5 seconds) a toast will last before disappearing
// It can be overridden per-toast by passing the `toastLifetimeMs` property - @see types.ts
exports.FLASH_MESSAGE_TYPES = FLASH_MESSAGE_TYPES;
const DEFAULT_TOAST_TIMEOUT = 5000;
exports.DEFAULT_TOAST_TIMEOUT = DEFAULT_TOAST_TIMEOUT;