"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _fetch_api_keys_logic = require("../../enterprise_search_overview/api/fetch_api_keys_logic");
var _kibana = require("../kibana");
var _create_api_key_flyout = require("./create_api_key_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COPIED_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.overview.apiKey.copied', {
  defaultMessage: 'Copied'
});
const ApiKeyPanel = () => {
  const {
    cloud,
    esConfig,
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    makeRequest
  } = (0, _kea.useActions)(_fetch_api_keys_logic.FetchApiKeysAPILogic);
  const {
    data
  } = (0, _kea.useValues)(_fetch_api_keys_logic.FetchApiKeysAPILogic);
  const [isFlyoutOpen, setIsFlyoutOpen] = (0, _react.useState)(false);
  const elasticsearchEndpoint = esConfig.elasticsearch_host;
  (0, _react.useEffect)(() => makeRequest({}), []);
  const apiKeys = (data === null || data === void 0 ? void 0 : data.api_keys) || [];
  const cloudId = cloud === null || cloud === void 0 ? void 0 : cloud.cloudId;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isFlyoutOpen && /*#__PURE__*/_react.default.createElement(_create_api_key_flyout.CreateApiKeyFlyout, {
    onClose: () => setIsFlyoutOpen(false)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, null, Boolean(cloud) && /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.elasticsearchEndpoint', {
    defaultMessage: 'Elasticsearch endpoint:'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    css: (0, _react2.css)`
                    overflow-wrap: anywhere;
                  `
  }, elasticsearchEndpoint)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: elasticsearchEndpoint || '',
    afterMessage: COPIED_LABEL
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: copy,
    iconType: "copyClipboard",
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.overview.apiKey.copyApiEndpoint', {
      defaultMessage: 'Copy Elasticsearch endpoint to clipboard.'
    })
  })))), Boolean(cloudId) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.cloudId', {
    defaultMessage: 'Cloud ID:'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    css: (0, _react2.css)`
                        overflow-wrap: anywhere;
                      `
  }, cloudId)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: cloudId || '',
    afterMessage: COPIED_LABEL
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: copy,
    iconType: "copyClipboard",
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.overview.apiKey.copyCloudID', {
      defaultMessage: 'Copy cloud ID to clipboard.'
    })
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.apiKey.activeKeys",
    defaultMessage: "{number} active API keys.",
    values: {
      number: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: apiKeys.length > 0 ? 'success' : 'warning',
        "data-test-subj": "api-keys-count-badge"
      }, apiKeys.length)
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircleFilled",
    size: "s",
    fill: true,
    onClick: () => setIsFlyoutOpen(true),
    "data-test-subj": "new-api-key-button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.newButtonLabel', {
    defaultMessage: 'New'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "popout",
    size: "s",
    onClick: () => navigateToUrl('/app/management/security/api_keys', {
      shouldNotCreateHref: true
    }),
    target: "_blank",
    "data-test-subj": "manage-api-keys-button"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.apiKey.manageLabel', {
    defaultMessage: 'Manage'
  }))))))));
};
exports.ApiKeyPanel = ApiKeyPanel;