"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validatePipelineNameIsAvailable = exports.validateInferencePipelineFields = exports.validateInferencePipelineConfiguration = exports.normalizeModelName = exports.isValidPipelineName = exports.TRAINED_MODELS_PATH = exports.MODEL_SELECT_PLACEHOLDER = exports.MODEL_REDACTED_VALUE = exports.EXISTING_PIPELINE_DISABLED_MISSING_SOURCE_FIELDS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VALID_PIPELINE_NAME_REGEX = /^[\w\-]+$/;
const NORMALIZABLE_PIPELINE_CHARS_REGEX = /[^\w\-]/g;
const TRAINED_MODELS_PATH = '/app/ml/trained_models';
exports.TRAINED_MODELS_PATH = TRAINED_MODELS_PATH;
const isValidPipelineName = input => {
  return input.length > 0 && VALID_PIPELINE_NAME_REGEX.test(input);
};
exports.isValidPipelineName = isValidPipelineName;
const INVALID_PIPELINE_NAME_ERROR = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.invalidPipelineName', {
  defaultMessage: 'Name must only contain letters, numbers, underscores, and hyphens.'
});
const FIELD_REQUIRED_ERROR = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.emptyValueError', {
  defaultMessage: 'Field is required.'
});
const PIPELINE_NAME_EXISTS_ERROR = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.pipelineNameExistsError', {
  defaultMessage: 'Name already used by another pipeline.'
});
const MODEL_NOT_DEPLOYED_ERROR = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.modelNotDeployedError', {
  defaultMessage: 'Model must be deployed before use.'
});
const validateInferencePipelineConfiguration = config => {
  const errors = {};
  if (config.existingPipeline === true) {
    if (config.pipelineName.length === 0) {
      errors.pipelineName = FIELD_REQUIRED_ERROR;
    }
    return errors;
  }
  if (config.pipelineName.trim().length === 0) {
    errors.pipelineName = FIELD_REQUIRED_ERROR;
  } else if (!isValidPipelineName(config.pipelineName)) {
    errors.pipelineName = INVALID_PIPELINE_NAME_ERROR;
  }
  if (config.modelID.trim().length === 0) {
    errors.modelID = FIELD_REQUIRED_ERROR;
  } else if (config.isModelPlaceholderSelected) {
    errors.modelStatus = MODEL_NOT_DEPLOYED_ERROR;
  }
  return errors;
};
exports.validateInferencePipelineConfiguration = validateInferencePipelineConfiguration;
const validatePipelineNameIsAvailable = existingPipeline => {
  const errors = {};
  if (existingPipeline !== undefined) {
    errors.pipelineName = PIPELINE_NAME_EXISTS_ERROR;
  }
  return errors;
};
exports.validatePipelineNameIsAvailable = validatePipelineNameIsAvailable;
const validateInferencePipelineFields = config => {
  var _config$fieldMappings;
  const errors = {};
  if (((_config$fieldMappings = config.fieldMappings) !== null && _config$fieldMappings !== void 0 ? _config$fieldMappings : []).length === 0) {
    errors.fieldMappings = FIELD_REQUIRED_ERROR;
  }
  return errors;
};
exports.validateInferencePipelineFields = validateInferencePipelineFields;
const normalizeModelName = modelName => {
  return modelName.replace(NORMALIZABLE_PIPELINE_CHARS_REGEX, '_');
};
exports.normalizeModelName = normalizeModelName;
const EXISTING_PIPELINE_DISABLED_MISSING_SOURCE_FIELDS = commaSeparatedMissingSourceFields => _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.existingPipeline.missingSourceFieldsDescription', {
  defaultMessage: 'Fields missing in this index: {commaSeparatedMissingSourceFields}',
  values: {
    commaSeparatedMissingSourceFields
  }
});
exports.EXISTING_PIPELINE_DISABLED_MISSING_SOURCE_FIELDS = EXISTING_PIPELINE_DISABLED_MISSING_SOURCE_FIELDS;
const MODEL_SELECT_PLACEHOLDER = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.model.placeholder', {
  defaultMessage: 'Select a model'
});
exports.MODEL_SELECT_PLACEHOLDER = MODEL_SELECT_PLACEHOLDER;
const MODEL_REDACTED_VALUE = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.model.redactedValue', {
  defaultMessage: "This model isn't available in the Kibana space"
});
exports.MODEL_REDACTED_VALUE = MODEL_REDACTED_VALUE;