"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferenceConfiguration = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _ml_inference_pipeline = require("../../../../../../../common/ml_inference_pipeline");
var _utils = require("../../../shared/ml_inference/utils");
var _ml_inference_logic = require("./ml_inference_logic");
var _zero_shot_inference_configuration = require("./zero_shot_inference_configuration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InferenceConfiguration = () => {
  const {
    addInferencePipelineModal: {
      configuration
    },
    selectedMLModel
  } = (0, _kea.useValues)(_ml_inference_logic.MLInferenceLogic);
  if (!selectedMLModel || configuration.existingPipeline) return null;
  const modelType = (0, _utils.getMLType)((0, _ml_inference_pipeline.getMlModelTypesForModelConfig)(selectedMLModel));
  switch (modelType) {
    case _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.ZERO_SHOT_CLASSIFICATION:
      return /*#__PURE__*/_react.default.createElement(InferenceConfigurationWrapper, null, /*#__PURE__*/_react.default.createElement(_zero_shot_inference_configuration.ZeroShotClassificationInferenceConfiguration, null));
    default:
      return null;
  }
};
exports.InferenceConfiguration = InferenceConfiguration;
const InferenceConfigurationWrapper = ({
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.inference.title', {
    defaultMessage: 'Inference Configuration'
  }))), children);
};