"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModelDeployed = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _e5_multilingual_callout = require("./e5_multilingual_callout");
var _e5_multilingual_callout_logic = require("./e5_multilingual_callout_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ModelDeployed = ({
  dismiss,
  ingestionMethod,
  isDismissable,
  isStartButtonDisabled
}) => {
  const {
    startE5MultilingualModel
  } = (0, _kea.useActions)(_e5_multilingual_callout_logic.E5MultilingualCalloutLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "primary",
    type: "checkInCircleFilled"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "primary",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.e5MultilingualCallOut.deployedTitle', {
    defaultMessage: 'Your E5 model has deployed but not started.'
  })))), isDismissable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_e5_multilingual_callout.E5MultilingualDismissButton, {
    dismiss: dismiss
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.e5MultilingualCallOut.deployedBody', {
    defaultMessage: 'You may start the model in a single-threaded configuration for testing, or tune the performance for a production environment.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-e5MultilingualCallOut-startModel`,
    disabled: isStartButtonDisabled,
    iconType: "playFilled",
    onClick: () => startE5MultilingualModel()
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.e5MultilingualCallOut.startModelButton.label', {
    defaultMessage: 'Start single-threaded'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_e5_multilingual_callout.FineTuneModelsButton, null))))));
};
exports.ModelDeployed = ModelDeployed;