"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigureFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _inference_config = require("./inference_config");
var _ml_inference_logic = require("./ml_inference_logic");
var _multi_field_selector = require("./multi_field_selector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigureFields = () => {
  const {
    addInferencePipelineModal: {
      configuration
    }
  } = (0, _kea.useValues)(_ml_inference_logic.MLInferenceLogic);
  const areInputsDisabled = configuration.existingPipeline !== false;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, areInputsDisabled ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.fields.titleReview",
    defaultMessage: "Review field mappings"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.fields.title",
    defaultMessage: "Select field mappings"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, areInputsDisabled ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.fields.descriptionReview",
    defaultMessage: "Examine the field mappings of your chosen pipeline to ensure that the source and target fields align with your specific use case. {notEditable}",
    values: {
      notEditable: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.fields.descriptionReviewNotEditable",
        defaultMessage: "The fields from existing pipelines are not editable."
      }))
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.fields.description",
    defaultMessage: "Choose fields to be enhanced from your existing documents or manually enter in fields you anticipate using."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, areInputsDisabled || /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_multi_field_selector.MultiFieldMapping, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_multi_field_selector.SelectedFieldMappings, {
    isReadOnly: areInputsDisabled
  }), /*#__PURE__*/_react.default.createElement(_inference_config.InferenceConfiguration, null)));
};
exports.ConfigureFields = ConfigureFields;