"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoConnectorRecordLogic = void 0;
var _kea = require("kea");
var _kibana = require("../../../../shared/kibana");
var _recreate_crawler_connector_api_logic = require("../../../api/crawler/recreate_crawler_connector_api_logic");
var _delete_index_api_logic = require("../../../api/index/delete_index_api_logic");
var _routes = require("../../../routes");
var _index_view_logic = require("../index_view_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoConnectorRecordLogic = (0, _kea.kea)({
  connect: {
    actions: [_recreate_crawler_connector_api_logic.RecreateCrawlerConnectorApiLogic, ['apiSuccess'], _index_view_logic.IndexViewLogic, ['fetchIndex'], _delete_index_api_logic.DeleteIndexApiLogic, ['apiSuccess as deleteSuccess']]
  },
  listeners: ({
    actions
  }) => ({
    apiSuccess: () => {
      actions.fetchIndex();
    },
    deleteSuccess: () => {
      _kibana.KibanaLogic.values.navigateToUrl(_routes.SEARCH_INDICES_PATH);
    }
  }),
  path: ['enterprise_search', 'content', 'no_connector_record']
});
exports.NoConnectorRecordLogic = NoConnectorRecordLogic;