"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeduplicationPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../../../shared/doc_links");
var _page_introduction = require("../../../../../../shared/page_introduction/page_introduction");
var _crawler_domain_detail_logic = require("../crawler_domain_detail_logic");
var _utils = require("./utils");
require("./deduplication_panel.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeduplicationPanel = () => {
  const {
    domain
  } = (0, _kea.useValues)(_crawler_domain_detail_logic.CrawlerDomainDetailLogic);
  const {
    submitDeduplicationUpdate
  } = (0, _kea.useActions)(_crawler_domain_detail_logic.CrawlerDomainDetailLogic);
  const [showAllFields, setShowAllFields] = (0, _react.useState)(true);
  const [showAllFieldsPopover, setShowAllFieldsPopover] = (0, _react.useState)(false);
  if (!domain) {
    return null;
  }
  const {
    deduplicationEnabled,
    deduplicationFields
  } = domain;
  const selectableOptions = (0, _utils.getSelectableOptions)(domain, showAllFields);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "deduplicationPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_page_introduction.PageIntroduction, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.deduplicationPanel.title', {
      defaultMessage: 'Duplicate document handling'
    }))),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-telemetry-id": "entSearchContent-crawler-domainDetail-deduplication-reset",
      color: "warning",
      iconType: "refresh",
      size: "s",
      onClick: () => submitDeduplicationUpdate({
        fields: []
      }),
      disabled: deduplicationFields.length === 0
    }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.deduplicationPanel.resetToDefaultsButtonLabel', {
      defaultMessage: 'Reset to defaults'
    })),
    description: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.crawler.deduplicationPanel.description",
      defaultMessage: "The web crawler only indexes unique pages. Choose which fields the crawler should use when considering which pages are duplicates. Deselect all schema fields to allow duplicate documents on this domain."
    })),
    links: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _doc_links.docLinks.crawlerManaging,
      external: true
    }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.deduplicationPanel.learnMoreMessage', {
      defaultMessage: 'Learn more about content hashing'
    }))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-telemetry-id": "entSearchContent-crawler-domainDetail-deduplication-preventDuplicates",
    label: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.deduplicationPanel.preventDuplicateLabel', {
      defaultMessage: 'Prevent duplicate documents'
    }),
    checked: deduplicationEnabled,
    onChange: () => deduplicationEnabled ? submitDeduplicationUpdate({
      enabled: false,
      fields: []
    }) : submitDeduplicationUpdate({
      enabled: true
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "selectableWrapper"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: selectableOptions,
    onChange: options => submitDeduplicationUpdate({
      fields: (0, _utils.getCheckedOptionLabels)(options)
    }),
    searchable: true,
    searchProps: {
      disabled: !deduplicationEnabled,
      append: /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          "data-telemetry-id": "entSearchContent-crawler-domainDetail-deduplication-selectFields",
          size: "xs",
          iconType: "arrowDown",
          iconSide: "right",
          onClick: () => setShowAllFieldsPopover(!showAllFieldsPopover),
          className: "showAllFieldsPopoverToggle",
          disabled: !deduplicationEnabled
        }, showAllFields ? _i18n.i18n.translate('xpack.enterpriseSearch.crawler.deduplicationPanel.allFieldsLabel', {
          defaultMessage: 'All fields'
        }) : _i18n.i18n.translate('xpack.enterpriseSearch.crawler.deduplicationPanel.selectedFieldsLabel', {
          defaultMessage: 'Selected fields'
        })),
        isOpen: showAllFieldsPopover,
        closePopover: () => setShowAllFieldsPopover(false),
        panelPaddingSize: "none",
        anchorPosition: "downLeft"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
        items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          "data-telemetry-id": "entSearchContent-crawler-domainDetail-deduplication-showAllFields",
          key: "all fields",
          icon: showAllFields ? 'check' : 'empty',
          onClick: () => {
            setShowAllFields(true);
            setShowAllFieldsPopover(false);
          }
        }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.deduplicationPanel.showAllFieldsButtonLabel', {
          defaultMessage: 'Show all fields'
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          "data-telemetry-id": "entSearchContent-crawler-domainDetail-deduplication-showSelectedFields",
          key: "selected fields",
          icon: showAllFields ? 'empty' : 'check',
          onClick: () => {
            setShowAllFields(false);
            setShowAllFieldsPopover(false);
          }
        }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlerStatusIndicator.showSelectedFieldsButtonLabel', {
          defaultMessage: 'Show only selected fields'
        }))]
      }))
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list))))));
};
exports.DeduplicationPanel = DeduplicationPanel;