"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyConfig = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api = require("../../../../../../common/types/api");
var _generate_connector_api_key_api_logic = require("../../../api/connector/generate_connector_api_key_api_logic");
var _api_key = require("../../api_key/api_key");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmModal = ({
  onCancel,
  onConfirm
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.apiKey.confirmModal.title', {
    defaultMessage: 'Generate an Elasticsearch API key'
  }),
  onCancel: onCancel,
  onConfirm: onConfirm,
  cancelButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.apiKey.confirmModal.cancelButton.label', {
    defaultMessage: 'Cancel'
  }),
  confirmButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.apiKey.confirmModal.confirmButton.label', {
    defaultMessage: 'Generate API key'
  }),
  defaultFocusedButton: "confirm"
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.apiKey.confirmModal.description', {
  defaultMessage: 'Generating a new API key will invalidate the previous key. Are you sure you want to generate a new API key? This can not be undone.'
}));
const ApiKeyConfig = ({
  hasApiKey,
  indexName
}) => {
  const {
    makeRequest,
    apiReset
  } = (0, _kea.useActions)(_generate_connector_api_key_api_logic.GenerateConnectorApiKeyApiLogic);
  const {
    data,
    status
  } = (0, _kea.useValues)(_generate_connector_api_key_api_logic.GenerateConnectorApiKeyApiLogic);
  (0, _react.useEffect)(() => {
    apiReset();
    return apiReset;
  }, [indexName]);
  const clickGenerateApiKey = () => {
    if (hasApiKey || data) {
      setIsModalVisible(true);
    } else {
      makeRequest({
        indexName
      });
    }
  };
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const onCancel = () => {
    setIsModalVisible(false);
  };
  const onConfirm = () => {
    makeRequest({
      indexName
    });
    setIsModalVisible(false);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, isModalVisible && /*#__PURE__*/_react.default.createElement(ConfirmModal, {
    onCancel: onCancel,
    onConfirm: onConfirm
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.apiKey.description', {
    defaultMessage: 'First, generate an Elasticsearch API key. This {apiKeyName} key will enable read and write permissions for the connector to index documents to the created {indexName} index. Save the key in a safe place, as you will need it to configure your connector.',
    values: {
      apiKeyName: `${indexName}-connector`,
      indexName
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: clickGenerateApiKey,
    isLoading: status === _api.Status.LOADING
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.apiKey.button.label', {
    defaultMessage: 'Generate API key'
  }))))), data && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_api_key.ApiKey, {
    apiKey: data === null || data === void 0 ? void 0 : data.encoded,
    label: "API Key"
  }))));
};
exports.ApiKeyConfig = ApiKeyConfig;