"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CannotConnect = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _routes = require("../../../routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CannotConnect = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    color: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.cannotConnect.title', {
      defaultMessage: 'Cannot connect to Enterprise Search'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.searchIndex.cannotConnect.body",
    defaultMessage: "The Elastic web crawler requires Enterprise Search. {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
        to: _routes.ERROR_STATE_PATH
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.cannotConnect.body', {
        defaultMessage: 'More information.'
      }))
    }
  })));
};
exports.CannotConnect = CannotConnect;