"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccessControlIndexSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const indexSelectorOptions = [{
  description: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.documents.selector.contentIndex.description', {
    defaultMessage: 'Browse content fields'
  }),
  title: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.documents.selector.contentIndex.title', {
    defaultMessage: 'Content index'
  }),
  value: 'content-index'
}, {
  description: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.documents.selector.accessControl.description', {
    defaultMessage: 'Browse document level security fields'
  }),
  title: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.documents.selector.accessControl.title', {
    defaultMessage: 'Access control index'
  }),
  value: 'access-control-index'
}];
const AccessControlIndexSelector = ({
  valueOfSelected,
  onChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    valueOfSelected: valueOfSelected,
    onChange: onChange,
    options: indexSelectorOptions.map(option => {
      return {
        dropdownDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
          gutterSize: "none"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
          size: "xs"
        }, /*#__PURE__*/_react.default.createElement("h4", null, option.title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs"
        }, /*#__PURE__*/_react.default.createElement("p", null, option.description)))),
        inputDisplay: option.title,
        value: option.value
      };
    })
  });
};
exports.AccessControlIndexSelector = AccessControlIndexSelector;