"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIngestionMethodIconType = getIngestionMethodIconType;
exports.getLanguageForOptimization = void 0;
var _constants = require("../../../../../common/constants");
var _connector = _interopRequireDefault(require("../../../../assets/source_icons/connector.svg"));
var _crawler = _interopRequireDefault(require("../../../../assets/source_icons/crawler.svg"));
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Enterprise Search expects the Universal language option to be represented by null
// but we can't use null as the value for an EuiSelectOption
const getLanguageForOptimization = language => language === _constants2.UNIVERSAL_LANGUAGE_VALUE ? null : language;
exports.getLanguageForOptimization = getLanguageForOptimization;
function getIngestionMethodIconType(type) {
  switch (type) {
    case _constants.INGESTION_METHOD_IDS.CRAWLER:
      return _crawler.default;
    case _constants.INGESTION_METHOD_IDS.CONNECTOR:
      return _connector.default;
    default:
      return 'consoleApp';
  }
}