"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchE5MultilingualModelStatus = exports.FetchE5MultilingualModelApiLogic = void 0;
var _create_api_logic = require("../../../../shared/api_logic/create_api_logic");
var _http = require("../../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchE5MultilingualModelStatus = async ({
  modelId
}) => {
  return await _http.HttpLogic.values.http.get(`/internal/enterprise_search/ml/models/${modelId}`);
};
exports.fetchE5MultilingualModelStatus = fetchE5MultilingualModelStatus;
const FetchE5MultilingualModelApiLogic = (0, _create_api_logic.createApiLogic)(['fetch_e5_multilingual_model_api_logic'], fetchE5MultilingualModelStatus, {
  showErrorFlash: false
});
exports.FetchE5MultilingualModelApiLogic = FetchE5MultilingualModelApiLogic;