"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cancelSyncs = exports.CancelSyncsApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cancelSyncs = async ({
  connectorId
}) => {
  const route = `/internal/enterprise_search/connectors/${connectorId}/cancel_syncs`;
  return await _http.HttpLogic.values.http.post(route);
};
exports.cancelSyncs = cancelSyncs;
const CancelSyncsApiLogic = (0, _create_api_logic.createApiLogic)(['cancel_syncs_api_logic'], cancelSyncs, {
  showSuccessFlashFn: () => _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.cancelSyncs.successMessage', {
    defaultMessage: 'Successfully canceled syncs'
  })
});
exports.CancelSyncsApiLogic = CancelSyncsApiLogic;