"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateSearchApplicationApiKey = exports.GenerateSearchApplicationApiKeyLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateSearchApplicationApiKey = async ({
  keyName,
  searchApplicationName
}) => {
  const route = `/internal/enterprise_search/search_applications/${searchApplicationName}/api_key`;
  return await _http.HttpLogic.values.http.post(route, {
    body: JSON.stringify({
      keyName
    })
  });
};
exports.generateSearchApplicationApiKey = generateSearchApplicationApiKey;
const GenerateSearchApplicationApiKeyLogic = (0, _create_api_logic.createApiLogic)(['generate_search_application_api_key_logic'], generateSearchApplicationApiKey);
exports.GenerateSearchApplicationApiKeyLogic = GenerateSearchApplicationApiKeyLogic;