"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SOURCE_ENGINES_TITLE = exports.REMOVE_SOURCE_ENGINE_SUCCESS_MESSAGE = exports.REMOVE_SOURCE_ENGINE_CONFIRM_DIALOGUE = exports.REMOVE_SOURCE_ENGINE_BUTTON_LABEL = exports.ADD_SOURCE_ENGINES_SUCCESS_MESSAGE = exports.ADD_SOURCE_ENGINES_PLACEHOLDER = exports.ADD_SOURCE_ENGINES_MODAL_TITLE = exports.ADD_SOURCE_ENGINES_MODAL_DESCRIPTION = exports.ADD_SOURCE_ENGINES_BUTTON_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SOURCE_ENGINES_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.souceEngines.title', {
  defaultMessage: 'Manage engines'
});
exports.SOURCE_ENGINES_TITLE = SOURCE_ENGINES_TITLE;
const ADD_SOURCE_ENGINES_BUTTON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.souceEngines.addSourceEnginesButtonLabel', {
  defaultMessage: 'Add engines'
});
exports.ADD_SOURCE_ENGINES_BUTTON_LABEL = ADD_SOURCE_ENGINES_BUTTON_LABEL;
const ADD_SOURCE_ENGINES_MODAL_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.souceEngines.addSourceEnginesModal.title', {
  defaultMessage: 'Add engines'
});
exports.ADD_SOURCE_ENGINES_MODAL_TITLE = ADD_SOURCE_ENGINES_MODAL_TITLE;
const ADD_SOURCE_ENGINES_MODAL_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.souceEngines.addSourceEnginesModal.description', {
  defaultMessage: 'Add additional engines to this meta engine.'
});
exports.ADD_SOURCE_ENGINES_MODAL_DESCRIPTION = ADD_SOURCE_ENGINES_MODAL_DESCRIPTION;
const ADD_SOURCE_ENGINES_PLACEHOLDER = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.souceEngines.addSourceEnginesPlaceholder', {
  defaultMessage: 'Select engine(s)'
});
exports.ADD_SOURCE_ENGINES_PLACEHOLDER = ADD_SOURCE_ENGINES_PLACEHOLDER;
const ADD_SOURCE_ENGINES_SUCCESS_MESSAGE = sourceEngineNames => _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.souceEngines.addSourceEnginesSuccessMessage', {
  defaultMessage: '{sourceEnginesCount, plural, one {# engine was} other {# engines were}} added to this meta engine',
  values: {
    sourceEnginesCount: sourceEngineNames.length
  }
});
exports.ADD_SOURCE_ENGINES_SUCCESS_MESSAGE = ADD_SOURCE_ENGINES_SUCCESS_MESSAGE;
const REMOVE_SOURCE_ENGINE_BUTTON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.sourceEngines.removeEngineButton.label', {
  defaultMessage: 'Remove from meta engine'
});
exports.REMOVE_SOURCE_ENGINE_BUTTON_LABEL = REMOVE_SOURCE_ENGINE_BUTTON_LABEL;
const REMOVE_SOURCE_ENGINE_CONFIRM_DIALOGUE = engineName => _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.sourceEngines.removeEngineConfirmDialogue.description', {
  defaultMessage: 'This will remove the engine, {engineName}, from this meta engine. All existing settings will be lost. Are you sure?',
  values: {
    engineName
  }
});
exports.REMOVE_SOURCE_ENGINE_CONFIRM_DIALOGUE = REMOVE_SOURCE_ENGINE_CONFIRM_DIALOGUE;
const REMOVE_SOURCE_ENGINE_SUCCESS_MESSAGE = engineName => _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.souceEngines.removeSourceEngineSuccessMessage', {
  defaultMessage: "Engine '{engineName}' was removed from this meta engine",
  values: {
    engineName
  }
});
exports.REMOVE_SOURCE_ENGINE_SUCCESS_MESSAGE = REMOVE_SOURCE_ENGINE_SUCCESS_MESSAGE;