"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TruncatedEnginesList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _routes = require("../../../routes");
var _encode_path_params = require("../../../utils/encode_path_params");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TruncatedEnginesList = ({
  engines,
  cutoff = 3
}) => {
  if (!(engines !== null && engines !== void 0 && engines.length)) return null;
  const displayedEngines = engines.slice(0, cutoff);
  const hiddenEngines = engines.slice(cutoff);
  const SEPARATOR = ', ';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, displayedEngines.map((engineName, i) => {
    const isLast = i === displayedEngines.length - 1;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: engineName
    }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
      to: (0, _encode_path_params.generateEncodedPath)(_routes.ENGINE_SCHEMA_PATH, {
        engineName
      }),
      "data-test-subj": "displayedEngine"
    }, engineName), !isLast ? SEPARATOR : '');
  }), hiddenEngines.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, SEPARATOR, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: hiddenEngines.join(SEPARATOR),
    "data-test-subj": "hiddenEnginesTooltip"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "both"
  }, "+", hiddenEngines.length))));
};
exports.TruncatedEnginesList = TruncatedEnginesList;