"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STANDARD_ROLE_TYPES = exports.SPECIFIC_ENGINES_LABEL = exports.SPECIFIC_ENGINES_DESCRIPTION = exports.ROLE_MAPPING_UPDATED_MESSAGE = exports.ROLE_MAPPING_DELETED_MESSAGE = exports.ROLE_MAPPING_CREATED_MESSAGE = exports.ROLE_MAPPINGS_ENGINE_ACCESS_HEADING = exports.OWNER_ROLE_TYPE_DESCRIPTION = exports.ENGINE_REQUIRED_ERROR = exports.ENGINE_ASSIGNMENT_LABEL = exports.EDITOR_ROLE_TYPE_DESCRIPTION = exports.DEV_ROLE_TYPE_DESCRIPTION = exports.ANALYST_ROLE_TYPE_DESCRIPTION = exports.ALL_ENGINES_LABEL = exports.ALL_ENGINES_DESCRIPTION = exports.ADVANCED_ROLE_TYPES = exports.ADMIN_ROLE_TYPE_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ROLE_MAPPING_DELETED_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.roleMappingDeletedMessage', {
  defaultMessage: 'Your role mapping was deleted'
});
exports.ROLE_MAPPING_DELETED_MESSAGE = ROLE_MAPPING_DELETED_MESSAGE;
const ROLE_MAPPING_CREATED_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.roleMappingCreatedMessage', {
  defaultMessage: 'Your role mapping was created'
});
exports.ROLE_MAPPING_CREATED_MESSAGE = ROLE_MAPPING_CREATED_MESSAGE;
const ROLE_MAPPING_UPDATED_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.roleMappingUpdatedMessage', {
  defaultMessage: 'Your role mapping was updated'
});
exports.ROLE_MAPPING_UPDATED_MESSAGE = ROLE_MAPPING_UPDATED_MESSAGE;
const ROLE_MAPPINGS_ENGINE_ACCESS_HEADING = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.roleMappingsEngineAccessHeading', {
  defaultMessage: 'Engine access'
});
exports.ROLE_MAPPINGS_ENGINE_ACCESS_HEADING = ROLE_MAPPINGS_ENGINE_ACCESS_HEADING;
const DEV_ROLE_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.DEV_ROLE_TYPE_DESCRIPTION', {
  defaultMessage: 'Devs can manage all aspects of an engine.'
});
exports.DEV_ROLE_TYPE_DESCRIPTION = DEV_ROLE_TYPE_DESCRIPTION;
const EDITOR_ROLE_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.editorRoleTypeDescription', {
  defaultMessage: 'Editors can manage search settings.'
});
exports.EDITOR_ROLE_TYPE_DESCRIPTION = EDITOR_ROLE_TYPE_DESCRIPTION;
const ANALYST_ROLE_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.analystRoleTypeDescription', {
  defaultMessage: 'Analysts can only view documents, query tester, and analytics.'
});
exports.ANALYST_ROLE_TYPE_DESCRIPTION = ANALYST_ROLE_TYPE_DESCRIPTION;
const OWNER_ROLE_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.ownerRoleTypeDescription', {
  defaultMessage: 'Owners can do anything. There can be many owners on the account, but there must be at least one owner at any time.'
});
exports.OWNER_ROLE_TYPE_DESCRIPTION = OWNER_ROLE_TYPE_DESCRIPTION;
const ADMIN_ROLE_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.adminRoleTypeDescription', {
  defaultMessage: 'Admins can do anything, except manage account settings.'
});
exports.ADMIN_ROLE_TYPE_DESCRIPTION = ADMIN_ROLE_TYPE_DESCRIPTION;
const ENGINE_REQUIRED_ERROR = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineRequiredError', {
  defaultMessage: 'At least one assigned engine is required.'
});
exports.ENGINE_REQUIRED_ERROR = ENGINE_REQUIRED_ERROR;
const ALL_ENGINES_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.allEnginesLabel', {
  defaultMessage: 'Assign to all engines'
});
exports.ALL_ENGINES_LABEL = ALL_ENGINES_LABEL;
const ALL_ENGINES_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.allEnginesDescription', {
  defaultMessage: 'Assigning to all engines includes all current and future engines as created and administered at a later date.'
});
exports.ALL_ENGINES_DESCRIPTION = ALL_ENGINES_DESCRIPTION;
const SPECIFIC_ENGINES_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.specificEnginesLabel', {
  defaultMessage: 'Assign to specific engines'
});
exports.SPECIFIC_ENGINES_LABEL = SPECIFIC_ENGINES_LABEL;
const SPECIFIC_ENGINES_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.specificEnginesDescription', {
  defaultMessage: 'Assign to a select set of engines statically.'
});
exports.SPECIFIC_ENGINES_DESCRIPTION = SPECIFIC_ENGINES_DESCRIPTION;
const ENGINE_ASSIGNMENT_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineAssignmentLabel', {
  defaultMessage: 'Engine assignment'
});
exports.ENGINE_ASSIGNMENT_LABEL = ENGINE_ASSIGNMENT_LABEL;
const ADVANCED_ROLE_TYPES = [{
  id: 'dev',
  description: DEV_ROLE_TYPE_DESCRIPTION
}, {
  id: 'editor',
  description: EDITOR_ROLE_TYPE_DESCRIPTION
}, {
  id: 'analyst',
  description: ANALYST_ROLE_TYPE_DESCRIPTION
}];
exports.ADVANCED_ROLE_TYPES = ADVANCED_ROLE_TYPES;
const STANDARD_ROLE_TYPES = [{
  id: 'owner',
  description: OWNER_ROLE_TYPE_DESCRIPTION
}, {
  id: 'admin',
  description: ADMIN_ROLE_TYPE_DESCRIPTION
}];
exports.STANDARD_ROLE_TYPES = STANDARD_ROLE_TYPES;