"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../shared/constants");
var _unsaved_changes_prompt = require("../../../shared/unsaved_changes_prompt");
var _constants2 = require("../../constants");
var _engine = require("../engine");
var _layout = require("../layout");
var _components = require("./components");
var _constants3 = require("./constants");
var _result_settings_table = require("./result_settings_table");
var _sample_response = require("./sample_response");
var _ = require(".");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLEAR_BUTTON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.clearButtonLabel', {
  defaultMessage: 'Clear all values'
});
const UNSAVED_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.unsavedChangesMessage', {
  defaultMessage: 'Result Settings have not been saved. Are you sure you want to leave?'
});
const ResultSettings = () => {
  const {
    dataLoading,
    schema,
    stagedUpdates,
    resultFieldsAtDefaultSettings,
    resultFieldsEmpty
  } = (0, _kea.useValues)(_.ResultSettingsLogic);
  const {
    initializeResultSettingsData,
    saveResultSettings,
    confirmResetAllFields,
    clearAllFields
  } = (0, _kea.useActions)(_.ResultSettingsLogic);
  (0, _react.useEffect)(() => {
    initializeResultSettingsData();
  }, []);
  const hasSchema = Object.keys(schema).length > 0;
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _engine.getEngineBreadcrumbs)([_constants3.RESULT_SETTINGS_TITLE]),
    pageHeader: {
      pageTitle: _constants3.RESULT_SETTINGS_TITLE,
      description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.pageDescription', {
        defaultMessage: 'Enrich search results and select which fields will appear.'
      }),
      rightSideItems: hasSchema ? [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "SaveResultSettings",
        color: "primary",
        fill: true,
        onClick: saveResultSettings,
        disabled: resultFieldsEmpty || !stagedUpdates
      }, _constants.SAVE_BUTTON_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "ResetResultSettings",
        color: "danger",
        onClick: confirmResetAllFields,
        disabled: resultFieldsAtDefaultSettings
      }, _constants2.RESTORE_DEFAULTS_BUTTON_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": "ClearResultSettings",
        onClick: clearAllFields
      }, CLEAR_BUTTON_LABEL)] : []
    },
    isLoading: dataLoading,
    isEmptyState: !hasSchema,
    emptyState: /*#__PURE__*/_react.default.createElement(_components.EmptyState, null)
  }, /*#__PURE__*/_react.default.createElement(_unsaved_changes_prompt.UnsavedChangesPrompt, {
    hasUnsavedChanges: stagedUpdates,
    messageText: UNSAVED_MESSAGE
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5
  }, /*#__PURE__*/_react.default.createElement(_result_settings_table.ResultSettingsTable, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_sample_response.SampleResponse, null))));
};
exports.ResultSettings = ResultSettings;